/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ha.store.spi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Properties;
import org.glassfish.ha.store.spi.BackingStoreException;
import org.glassfish.ha.store.spi.BackingStoreFactory;
import org.glassfish.ha.store.spi.DuplicateFactoryRegistrationException;

public final class BackingStoreFactoryRegistry {
    private static final HashMap<String, RegistrationInfo> factoryRegistrations = new HashMap();
    private static final HashMap<String, BackingStoreFactory> factories = new HashMap();

    public static synchronized void register(String type, String factoryClassName, Properties props) throws DuplicateFactoryRegistrationException {
        if (factoryRegistrations.get(type) != null) {
            throw new DuplicateFactoryRegistrationException("BackingStoreFactory for persistene-type " + type + " already exists");
        }
        RegistrationInfo regInfo = new RegistrationInfo(factoryClassName, props);
        factoryRegistrations.put(type, regInfo);
    }

    public static synchronized void register(String type, Class factoryClass, Properties props) throws DuplicateFactoryRegistrationException {
        if (factoryRegistrations.get(type) != null) {
            throw new DuplicateFactoryRegistrationException("BackingStoreFactory for persistene-type " + type + " already exists");
        }
        RegistrationInfo regInfo = new RegistrationInfo(factoryClass.getName(), props);
        factoryRegistrations.put(type, regInfo);
    }

    public static synchronized BackingStoreFactory getFactoryInstance(String type) throws BackingStoreException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        BackingStoreFactory factory = factories.get(type);
        if (factory == null) {
            RegistrationInfo regInfo = factoryRegistrations.get(type);
            if (regInfo != null) {
                try {
                    Class<?> clazz = Class.forName(regInfo.factoryClassName);
                    Constructor<?> con = clazz.getConstructor(Properties.class);
                    factory = (BackingStoreFactory)con.newInstance(regInfo.props);
                    factories.put(type, factory);
                }
                catch (NoSuchMethodException nme) {
                    throw new BackingStoreException(nme.getMessage(), nme.getCause());
                }
                catch (InvocationTargetException ite) {
                    throw new BackingStoreException(ite.getMessage(), ite.getCause());
                }
            } else {
                throw new BackingStoreException("Backing store for persistence-type " + type + " is not registered.");
            }
        }
        return factory;
    }

    public static synchronized void unregister(String type) {
        factoryRegistrations.remove(type);
        factories.remove(type);
    }

    static class RegistrationInfo {
        String factoryClassName;
        Properties props;

        RegistrationInfo(String factoryClassName, Properties props) {
            this.factoryClassName = factoryClassName;
            this.props = props;
        }
    }
}

