/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.httpserver.nonblockinghandler;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.http.io.NIOInputStream;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.http.util.HttpStatus;

public class UploadHttpHandlerSample {
    private static final Logger LOGGER = Grizzly.logger(UploadHttpHandlerSample.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        HttpServer server = HttpServer.createSimpleServer();
        ServerConfiguration config = server.getServerConfiguration();
        config.addHttpHandler((HttpHandler)new NonBlockingUploadHandler(), new String[]{"/upload"});
        try {
            server.start();
            LOGGER.info("Press enter to stop the server...");
            System.in.read();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
        }
        finally {
            server.shutdownNow();
        }
    }

    private static class NonBlockingUploadHandler
    extends HttpHandler {
        private final AtomicInteger counter = new AtomicInteger();

        private NonBlockingUploadHandler() {
        }

        public void service(Request request, final Response response) throws Exception {
            final NIOInputStream in = request.getNIOInputStream();
            final FileChannel fileChannel = new FileOutputStream("./" + this.counter.incrementAndGet() + ".upload").getChannel();
            response.suspend();
            in.notifyAvailable(new ReadHandler(){

                public void onDataAvailable() throws Exception {
                    LOGGER.log(Level.FINE, "[onDataAvailable] length: {0}", in.readyData());
                    NonBlockingUploadHandler.storeAvailableData(in, fileChannel);
                    in.notifyAvailable((ReadHandler)this);
                }

                public void onError(Throwable t) {
                    LOGGER.log(Level.WARNING, "[onError]", t);
                    response.setStatus(500, t.getMessage());
                    this.complete(true);
                    if (response.isSuspended()) {
                        response.resume();
                    } else {
                        response.finish();
                    }
                }

                public void onAllDataRead() throws Exception {
                    LOGGER.log(Level.FINE, "[onAllDataRead] length: {0}", in.readyData());
                    NonBlockingUploadHandler.storeAvailableData(in, fileChannel);
                    response.setStatus(HttpStatus.ACCEPTED_202);
                    this.complete(false);
                    response.resume();
                }

                private void complete(boolean isError) {
                    block5: {
                        block4: {
                            try {
                                fileChannel.close();
                            }
                            catch (IOException e) {
                                if (isError) break block4;
                                response.setStatus(500, e.getMessage());
                            }
                        }
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            if (isError) break block5;
                            response.setStatus(500, e.getMessage());
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void storeAvailableData(NIOInputStream in, FileChannel fileChannel) throws IOException {
            Buffer buffer = in.readBuffer();
            ByteBuffer byteBuffer = buffer.toByteBuffer();
            try {
                while (byteBuffer.hasRemaining()) {
                    fileChannel.write(byteBuffer);
                }
            }
            finally {
                buffer.tryDispose();
            }
        }
    }
}

