/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.echo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.samples.echo.ClientFilter;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.grizzly.utils.StringFilter;

public class EchoClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, ExecutionException, InterruptedException, TimeoutException {
        Connection connection = null;
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new StringFilter(Charset.forName("UTF-8")));
        filterChainBuilder.add((Filter)new ClientFilter());
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            String userInput;
            transport.start();
            GrizzlyFuture future = transport.connect("localhost", 7777);
            connection = (Connection)future.get(10L, TimeUnit.SECONDS);
            assert (connection != null);
            System.out.println("Ready... (\"q\" to exit)");
            BufferedReader inReader = new BufferedReader(new InputStreamReader(System.in, Charsets.ASCII_CHARSET));
            while ((userInput = inReader.readLine()) != null) {
                if ("q".equals(userInput)) {
                    break;
                }
                connection.write((Object)userInput);
            }
        }
        finally {
            if (connection != null) {
                connection.closeSilently();
            }
            transport.shutdownNow();
        }
    }
}

