/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.echo;

import java.io.IOException;
import java.nio.charset.Charset;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.samples.echo.EchoFilter;
import org.glassfish.grizzly.utils.StringFilter;
import org.slf4j.Logger;

public class EchoServer {
    private static final Logger logger = Grizzly.logger(EchoServer.class);
    public static final String HOST = "localhost";
    public static final int PORT = 7777;

    public static void main(String[] args) throws IOException {
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new StringFilter(Charset.forName("UTF-8")));
        filterChainBuilder.add((Filter)new EchoFilter());
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.bind(HOST, 7777);
            transport.start();
            logger.info("Press any key to stop the server...");
            System.in.read();
        }
        finally {
            logger.info("Stopping transport...");
            transport.shutdownNow();
            logger.info("Stopped transport...");
        }
    }
}

