/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.ssl;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.samples.echo.EchoFilter;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.utils.StringFilter;

public class SSLEchoServer {
    public static final String HOST = "localhost";
    public static final int PORT = 7777;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        SSLEngineConfigurator serverConfig = SSLEchoServer.initializeSSL();
        SSLEngineConfigurator clientConfig = serverConfig.copy().setClientMode(true);
        filterChainBuilder.add((Filter)new SSLFilter(serverConfig, clientConfig));
        filterChainBuilder.add((Filter)new StringFilter(Charset.forName("UTF-8")));
        filterChainBuilder.add((Filter)new EchoFilter());
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.bind(HOST, 7777);
            transport.start();
            System.out.println("Press any key to stop the server...");
            System.in.read();
        }
        finally {
            System.out.println("Stopping transport...");
            transport.shutdownNow();
            System.out.println("Stopped transport...");
        }
    }

    private static SSLEngineConfigurator initializeSSL() {
        URL keystoreUrl;
        SSLContextConfigurator sslContextConfig = new SSLContextConfigurator();
        ClassLoader cl = SSLEchoServer.class.getClassLoader();
        URL cacertsUrl = cl.getResource("ssltest-cacerts.jks");
        if (cacertsUrl != null) {
            sslContextConfig.setTrustStoreFile(cacertsUrl.getFile());
            sslContextConfig.setTrustStorePass("changeit");
        }
        if ((keystoreUrl = cl.getResource("ssltest-keystore.jks")) != null) {
            sslContextConfig.setKeyStoreFile(keystoreUrl.getFile());
            sslContextConfig.setKeyStorePass("changeit");
        }
        return new SSLEngineConfigurator(sslContextConfig.createSSLContext(), false, false, false);
    }
}

