/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.servlet.CookieWrapper;
import org.glassfish.grizzly.servlet.Holders;
import org.glassfish.grizzly.servlet.HttpServletRequestImpl;
import org.glassfish.grizzly.servlet.ServletOutputStreamImpl;
import org.glassfish.grizzly.servlet.ServletWriterImpl;

public class HttpServletResponseImpl
implements HttpServletResponse,
Holders.ResponseHolder {
    private final ServletOutputStreamImpl outputStream = new ServletOutputStreamImpl(this);
    private ServletWriterImpl writer;
    protected boolean usingOutputStream = false;
    protected boolean usingWriter = false;
    private static final ThreadCache.CachedTypeIndex<HttpServletResponseImpl> CACHE_IDX = ThreadCache.obtainIndex(HttpServletResponseImpl.class, 2);
    protected Response response = null;
    protected HttpServletRequestImpl servletRequest;

    public static HttpServletResponseImpl create() {
        HttpServletResponseImpl response = ThreadCache.takeFromCache(CACHE_IDX);
        if (response != null) {
            return response;
        }
        return new HttpServletResponseImpl();
    }

    protected HttpServletResponseImpl() {
    }

    public void initialize(Response response, HttpServletRequestImpl servletRequest) throws IOException {
        this.response = response;
        this.servletRequest = servletRequest;
        this.outputStream.initialize();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void finish() throws IOException {
        if (this.response == null) {
            throw new IllegalStateException("Null response object");
        }
        this.response.finish();
    }

    @Override
    public String getCharacterEncoding() {
        if (this.response == null) {
            throw new IllegalStateException("Null response object");
        }
        return this.response.getCharacterEncoding();
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this.usingWriter) {
            throw new IllegalStateException("Illegal attempt to call getOutputStream() after getWriter() has already been called.");
        }
        this.usingOutputStream = true;
        return this.outputStream;
    }

    void recycle() {
        this.response = null;
        this.servletRequest = null;
        this.writer = null;
        this.outputStream.recycle();
        this.usingOutputStream = false;
        this.usingWriter = false;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.usingOutputStream) {
            throw new IllegalStateException("Illegal attempt to call getWriter() after getOutputStream has already been called.");
        }
        this.usingWriter = true;
        if (this.writer == null) {
            this.writer = new ServletWriterImpl(this.response.getWriter());
        }
        return this.writer;
    }

    @Override
    public void setContentLength(int len) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLength(len);
    }

    @Override
    public void setContentLengthLong(long len) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLengthLong(len);
    }

    @Override
    public void setContentType(String type) {
        if (this.isCommitted()) {
            return;
        }
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new SetContentTypePrivilegedAction(type));
        } else {
            this.response.setContentType(type);
        }
    }

    @Override
    public void setBufferSize(int size) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Illegal attempt to adjust the buffer size after the response has already been committed.");
        }
        this.response.setBufferSize(size);
    }

    @Override
    public int getBufferSize() {
        if (this.response == null) {
            throw new IllegalStateException("Null response object");
        }
        return this.response.getBufferSize();
    }

    @Override
    public void flushBuffer() throws IOException {
        block3: {
            if (System.getSecurityManager() == null) {
                this.response.flush();
                return;
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        HttpServletResponseImpl.this.response.flush();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (!(ex instanceof IOException)) break block3;
                throw (IOException)ex;
            }
        }
    }

    @Override
    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Illegal attempt to reset the buffer after the response has already been committed.");
        }
        this.response.resetBuffer();
    }

    @Override
    public boolean isCommitted() {
        if (this.response == null) {
            throw new IllegalStateException("Null response object");
        }
        return this.response.isCommitted();
    }

    @Override
    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Illegal attempt to reset the response after it has already been committed.");
        }
        this.response.reset();
    }

    @Override
    public void setLocale(Locale loc) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setLocale(loc);
    }

    @Override
    public Locale getLocale() {
        if (this.response == null) {
            throw new IllegalStateException("Null response object");
        }
        return this.response.getLocale();
    }

    @Override
    public void addCookie(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        CookieWrapper wrapper = new CookieWrapper(cookie.getName(), cookie.getValue());
        wrapper.setWrappedCookie(cookie);
        this.response.addCookie(wrapper);
    }

    @Override
    public boolean containsHeader(String name) {
        if (this.response == null) {
            throw new IllegalStateException("Null response object");
        }
        return this.response.containsHeader(name);
    }

    @Override
    public String encodeURL(String url) {
        if (this.response == null) {
            throw new IllegalStateException("Null response object");
        }
        return this.response.encodeURL(url);
    }

    @Override
    public String encodeRedirectURL(String url) {
        if (this.response == null) {
            throw new IllegalStateException("Null response object");
        }
        return this.response.encodeRedirectURL(url);
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Illegal attempt to call sendError() after the response has been committed.");
        }
        this.response.sendError(sc, msg);
    }

    @Override
    public void sendError(int sc) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Illegal attempt to call sendError() after the response has already been committed.");
        }
        this.response.sendError(sc);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Illegal attempt to redirect the response after it has been committed.");
        }
        this.response.sendRedirect(location);
    }

    @Override
    public void sendRedirect(String location, int sc, boolean clearBuffer) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Illegal attempt to redirect the response after it has been committed.");
        }
        this.response.sendRedirect(location);
    }

    @Override
    public String getHeader(String string) {
        return this.response.getHeader(string);
    }

    @Override
    public Collection<String> getHeaderNames() {
        return new ArrayList<String>(Arrays.asList(this.response.getHeaderNames()));
    }

    @Override
    public Collection<String> getHeaders(String string) {
        return new ArrayList<String>(Arrays.asList(this.response.getHeaderValues(string)));
    }

    @Override
    public void setDateHeader(String name, long date) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setDateHeader(name, date);
    }

    @Override
    public void addDateHeader(String name, long date) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addDateHeader(name, date);
    }

    @Override
    public void setHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addHeader(name, value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setIntHeader(name, value);
    }

    @Override
    public void addIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addIntHeader(name, value);
    }

    @Override
    public void setStatus(int sc) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setStatus(sc);
    }

    @Override
    public int getStatus() {
        return this.response.getStatus();
    }

    public String getMessage() {
        return this.response.getMessage();
    }

    public boolean isError() {
        return this.response.isError();
    }

    @Override
    public String getContentType() {
        return this.response.getContentType();
    }

    @Override
    public void setCharacterEncoding(String charEnc) {
        this.response.setCharacterEncoding(charEnc);
    }

    public Response getResponse() {
        return this.response;
    }

    @Override
    public Response getInternalResponse() {
        return this.response;
    }

    @Override
    public void setTrailerFields(Supplier<Map<String, String>> supplier) {
        this.response.setTrailers(supplier);
    }

    @Override
    public Supplier<Map<String, String>> getTrailerFields() {
        return this.response.getTrailers();
    }

    private final class SetContentTypePrivilegedAction
    implements PrivilegedAction {
        private final String contentType;

        public SetContentTypePrivilegedAction(String contentType) {
            this.contentType = contentType;
        }

        public Object run() {
            HttpServletResponseImpl.this.response.setContentType(this.contentType);
            return null;
        }
    }
}

