/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.comet;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GenericCloseListener;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.comet.CometEngine;
import org.glassfish.grizzly.comet.CometEvent;
import org.glassfish.grizzly.comet.CometHandler;
import org.glassfish.grizzly.comet.NotificationHandler;
import org.glassfish.grizzly.http.io.NIOInputStream;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.TimeoutHandler;
import org.glassfish.grizzly.http.util.Header;

public class CometContext<E> {
    protected static final String INVALID_COMET_HANDLER = "CometHandler cannot be null. This CometHandler was probably resumed and an invalid reference was made to it.";
    protected static final String ALREADY_REMOVED = "CometHandler already been removed or invalid.";
    private static final String COMET_NOT_ENABLED = "Make sure you have enabled Comet or make sure the thread invoking that method is the same as the Servlet.service() thread.";
    protected static final Logger LOGGER = Logger.getLogger(CometContext.class.getName());
    private final Map<Object, Object> attributes;
    protected static final ThreadLocal<Request> REQUEST_LOCAL = new ThreadLocal();
    protected String topic;
    private long expirationDelay;
    protected NotificationHandler notificationHandler;
    private final List<CometHandler> handlers;
    protected final CometEvent<CometContext> eventInterrupt;
    protected final CometEvent<CometContext> eventTerminate;
    private final CometEvent<CometContext> eventInitialize;
    private boolean isDetectClosedConnections = true;

    public CometContext(String contextTopic) {
        this.topic = contextTopic;
        this.attributes = new ConcurrentHashMap<Object, Object>();
        this.handlers = new CopyOnWriteArrayList<CometHandler>();
        this.eventInterrupt = new CometEvent(CometEvent.Type.INTERRUPT, this);
        this.eventInitialize = new CometEvent(CometEvent.Type.INITIALIZE, this);
        this.eventTerminate = new CometEvent<CometContext>(CometEvent.Type.TERMINATE, this, this);
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.expirationDelay = -1L;
    }

    @Deprecated
    public String getContextPath() {
        return this.getTopic();
    }

    public String getTopic() {
        return this.topic;
    }

    public void addAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    public int addCometHandler(CometHandler<E> handler) {
        if (handler == null) {
            throw new IllegalStateException(INVALID_COMET_HANDLER);
        }
        if (!CometEngine.getEngine().isCometEnabled()) {
            throw new IllegalStateException(COMET_NOT_ENABLED);
        }
        Request request = REQUEST_LOCAL.get();
        Response response = request.getResponse();
        Connection c = request.getContext().getConnection();
        handler.setResponse(response);
        handler.setCometContext(this);
        try {
            this.initialize(handler);
            CometCompletionHandler ccHandler = new CometCompletionHandler(handler);
            c.addCloseListener(ccHandler);
            response.suspend(this.getExpirationDelay(), TimeUnit.MILLISECONDS, ccHandler, new CometTimeoutHandler(handler));
            if (this.isDetectClosedConnections) {
                response.addHeader(Header.Connection, "close");
                response.getRequest().getInputBuffer().initiateAsyncronousDataReceiving();
            }
            this.handlers.add(handler);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return handler.hashCode();
    }

    public void recycle() {
        try {
            this.notificationHandler.notify(new CometEvent<Object>(CometEvent.Type.TERMINATE, this, null), this.handlers.iterator());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.handlers.clear();
        this.attributes.clear();
        this.topic = null;
        this.notificationHandler = null;
        this.initDefaultValues();
    }

    protected void invokeCometHandler(CometEvent event, CometHandler cometHandler) throws IOException {
        if (cometHandler == null) {
            throw new IllegalStateException(INVALID_COMET_HANDLER);
        }
        event.setCometContext(this);
        cometHandler.onEvent(event);
    }

    public boolean removeCometHandler(CometHandler handler) {
        return this.removeCometHandler(handler, true);
    }

    public boolean removeCometHandler(CometHandler handler, boolean resume) {
        boolean removed = this.handlers.remove(handler);
        if (removed && resume) {
            handler.getResponse().resume();
        }
        return removed;
    }

    public boolean resumeCometHandler(CometHandler handler) throws IOException {
        return this.interrupt(handler, false);
    }

    public boolean interrupt(CometHandler handler, boolean finishExecution) throws IOException {
        CometContext cometContext = handler.getCometContext();
        boolean removed = cometContext.removeCometHandler(handler, finishExecution);
        if (removed && !finishExecution) {
            this.interrupt0(handler, finishExecution);
        }
        return removed;
    }

    protected void interrupt0(CometHandler handler, boolean finishExecution) throws IOException {
        if (finishExecution) {
            try {
                handler.onInterrupt(this.eventInterrupt);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        handler.getResponse().resume();
    }

    public boolean isActive(CometHandler handler) {
        return this.handlers.contains(handler);
    }

    public void notify(E attachment) throws IOException {
        this.notify(attachment, CometEvent.Type.NOTIFY);
    }

    public void notify(E attachment, CometHandler cometHandler) throws IOException {
        this.notify(attachment, CometEvent.Type.NOTIFY, cometHandler);
    }

    public void notify(E attachment, CometEvent.Type eventType, CometHandler cometHandler) throws IOException {
        if (cometHandler == null) {
            throw new IllegalStateException(INVALID_COMET_HANDLER);
        }
        CometEvent<E> event = new CometEvent<E>(eventType, this, attachment);
        this.notificationHandler.notify(event, cometHandler);
    }

    public void notify(E attachment, CometEvent.Type eventType) throws IOException {
        this.notificationHandler.notify(new CometEvent<E>(eventType, this, attachment), this.handlers.iterator());
    }

    protected void initialize(CometHandler handler) throws IOException {
        handler.onInitialize(this.eventInitialize);
    }

    public String toString() {
        return this.topic;
    }

    public long getExpirationDelay() {
        return this.expirationDelay;
    }

    public void setExpirationDelay(long expirationDelay) {
        this.expirationDelay = expirationDelay;
    }

    public List<CometHandler> getCometHandlers() {
        return this.handlers;
    }

    public void setNotificationHandler(NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    public void setDetectClosedConnections(boolean isDetectClosedConnections) {
        this.isDetectClosedConnections = isDetectClosedConnections;
    }

    public boolean isDetectClosedConnections() {
        return this.isDetectClosedConnections;
    }

    private static void notifyOnAsyncRead(CometHandler handler) {
        try {
            handler.onEvent(new CometEvent(CometEvent.Type.READ));
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, e.getMessage());
        }
    }

    private static class CometInputHandler
    implements ReadHandler {
        final NIOInputStream nioInputStream;
        private final CometHandler handler;

        public CometInputHandler(NIOInputStream nioInputStream, CometHandler handler) {
            this.nioInputStream = nioInputStream;
            this.handler = handler;
        }

        @Override
        public void onDataAvailable() {
            CometContext.notifyOnAsyncRead(this.handler);
            this.nioInputStream.notifyAvailable(this);
        }

        @Override
        public void onError(Throwable t) {
        }

        @Override
        public void onAllDataRead() {
            if (this.nioInputStream.isReady()) {
                CometContext.notifyOnAsyncRead(this.handler);
            }
        }
    }

    private class CometTimeoutHandler
    implements TimeoutHandler {
        private final CometHandler handler;

        public CometTimeoutHandler(CometHandler handler) {
            this.handler = handler;
        }

        @Override
        public boolean onTimeout(Response response) {
            try {
                this.handler.onInterrupt(CometContext.this.eventInterrupt);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
                throw new RuntimeException(e.getMessage(), e);
            }
            return true;
        }
    }

    private class CometCompletionHandler
    implements CompletionHandler<Response>,
    GenericCloseListener {
        private final CometHandler handler;

        public CometCompletionHandler(CometHandler handler) {
            this.handler = handler;
        }

        @Override
        public void cancelled() {
        }

        @Override
        public void failed(Throwable throwable) {
            try {
                this.handler.onInterrupt(CometContext.this.eventInterrupt);
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "CometCompletionHandler.failed", e.getMessage());
            }
        }

        @Override
        public void completed(Response result) {
            try {
                this.handler.onInterrupt(CometContext.this.eventInterrupt);
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "CometCompletionHandler.completed", e.getMessage());
            }
        }

        @Override
        public void updated(Response result) {
        }

        @Override
        public void onClosed(Closeable closeable, CloseType type) throws IOException {
            CometContext.this.removeCometHandler(this.handler);
            closeable.removeCloseListener(this);
        }
    }
}

