/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.comet;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.comet.CometContext;
import org.glassfish.grizzly.comet.CometHandler;
import org.glassfish.grizzly.comet.DefaultNotificationHandler;
import org.glassfish.grizzly.comet.NotificationHandler;
import org.glassfish.grizzly.localization.LogMessages;

public class CometEngine {
    @Deprecated
    public static final int DISABLE_SUSPEND_TIMEOUT = -1;
    @Deprecated
    public static final int DISABLE_CLIENT_DISCONNECTION_DETECTION = 0;
    @Deprecated
    public static final int BEFORE_REQUEST_PROCESSING = 0;
    @Deprecated
    public static final int AFTER_SERVLET_PROCESSING = 1;
    @Deprecated
    public static final int AFTER_RESPONSE_PROCESSING = 2;
    protected static final Logger logger = Logger.getLogger(CometEngine.class.getName());
    protected ExecutorService threadPool;
    private static final CometEngine cometEngine = new CometEngine();
    protected final Map<String, CometContext> activeContexts = new ConcurrentHashMap<String, CometContext>(16, 0.75f, 64);
    private boolean isCometSupported;

    protected CometEngine() {
    }

    protected boolean isCometEnabled() {
        return this.isCometSupported;
    }

    public void setCometSupported(boolean supported) {
        this.isCometSupported = supported;
    }

    public static CometEngine getEngine() {
        return cometEngine;
    }

    @Deprecated
    public CometContext unregister(String topic) {
        return this.deregister(topic);
    }

    public CometContext deregister(String topic) {
        CometContext cometContext = this.activeContexts.remove(topic);
        if (cometContext != null) {
            cometContext.recycle();
        }
        return cometContext;
    }

    public <E> CometContext<E> register(String topic, int type) {
        return this.register(topic);
    }

    public <E> CometContext<E> register(String topic) {
        return this.register(topic, DefaultNotificationHandler.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> CometContext<E> register(String topic, Class<? extends NotificationHandler> notificationClass) {
        CometContext cometContext = this.activeContexts.get(topic);
        if (cometContext == null) {
            Map<String, CometContext> map = this.activeContexts;
            synchronized (map) {
                cometContext = this.activeContexts.get(topic);
                if (cometContext == null) {
                    NotificationHandler notificationHandler;
                    cometContext = new CometContext(this, topic);
                    try {
                        notificationHandler = notificationClass.newInstance();
                    }
                    catch (Throwable t) {
                        if (logger.isLoggable(Level.SEVERE)) {
                            logger.log(Level.SEVERE, LogMessages.SEVERE_GRIZZLY_COMET_ENGINE_INVALID_NOTIFICATION_HANDLER_ERROR(notificationClass.getName()), t);
                        }
                        notificationHandler = new DefaultNotificationHandler();
                    }
                    cometContext.setNotificationHandler(notificationHandler);
                    if (notificationHandler != null && notificationHandler instanceof DefaultNotificationHandler) {
                        ((DefaultNotificationHandler)notificationHandler).setThreadPool(this.threadPool);
                    }
                    this.activeContexts.put(topic, cometContext);
                }
            }
        }
        return cometContext;
    }

    public <E> CometContext<E> getCometContext(String topic) {
        return this.activeContexts.get(topic);
    }

    protected boolean interrupt(CometHandler handler, boolean finishExecution) throws IOException {
        CometContext cometContext = handler.getCometContext();
        boolean removed = cometContext.removeCometHandler(handler, finishExecution);
        if (removed && !finishExecution) {
            this.interrupt0(handler, finishExecution);
        }
        return removed;
    }

    protected void interrupt0(CometHandler handler, boolean finishExecution) throws IOException {
        if (finishExecution) {
            try {
                handler.onInterrupt(handler.getCometContext().eventInterrupt);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        handler.getResponse().finish();
    }

    public static Logger logger() {
        return logger;
    }
}

