/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GenericCloseListener;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.websockets.ClosingFrame;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.Version;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketHolder;
import org.glassfish.grizzly.websockets.WebSocketMappingData;

public class WebSocketEngine {
    public static final Version DEFAULT_VERSION = Version.RFC6455;
    public static final int DEFAULT_TIMEOUT = 30;
    private static final WebSocketEngine engine = new WebSocketEngine();
    static final Logger logger = Logger.getLogger("websocket");
    private final List<WebSocketApplication> applications = new ArrayList<WebSocketApplication>();
    private final HashMap<WebSocketApplication, String> applicationMap = new HashMap();
    private final HashMap<String, List<WebSocketApplication>> contextApplications = new HashMap();
    private HttpResponsePacket.Builder unsupportedVersionsResponseBuilder;
    private Mapper mapper = new Mapper();

    private WebSocketEngine() {
        this.mapper.setDefaultHostName("localhost");
        this.unsupportedVersionsResponseBuilder = new HttpResponsePacket.Builder();
        this.unsupportedVersionsResponseBuilder.status(HttpStatus.BAD_REQUEST_400.getStatusCode());
        this.unsupportedVersionsResponseBuilder.header("Sec-WebSocket-Version", Version.getSupportedWireProtocolVersions());
    }

    public static WebSocketEngine getEngine() {
        return engine;
    }

    public WebSocketApplication getApplication(HttpRequestPacket request) {
        return this.getApplication(request, this.mapper).app;
    }

    private WebSocketApplicationReg getApplication(HttpRequestPacket request, Mapper glassfishMapper) {
        WebSocketMappingData data;
        WebSocketApplication foundWebSocketApp;
        block11: {
            boolean isGlassfish;
            block10: {
                isGlassfish = glassfishMapper != null;
                foundWebSocketApp = null;
                data = new WebSocketMappingData(isGlassfish);
                try {
                    this.mapper.mapUriWithSemicolon(request, request.getRequestURIRef().getDecodedRequestURIBC(), (MappingData)data, 0);
                    if (data.wrapper != null) {
                        foundWebSocketApp = (WebSocketApplication)data.wrapper;
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.WARNING)) break block10;
                    logger.log(Level.WARNING, e.toString(), e);
                }
            }
            if (foundWebSocketApp == null) {
                for (WebSocketApplication application : this.applications) {
                    if (!application.upgrade(request)) continue;
                    foundWebSocketApp = application;
                    break;
                }
            }
            if (foundWebSocketApp == null) {
                return null;
            }
            if (isGlassfish) {
                assert (glassfishMapper != null);
                try {
                    data.recycle();
                    glassfishMapper.mapUriWithSemicolon(request, request.getRequestURIRef().getDecodedRequestURIBC(), (MappingData)data, 0);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.WARNING)) break block11;
                    logger.log(Level.WARNING, e.toString(), e);
                }
            }
        }
        return new WebSocketApplicationReg(foundWebSocketApp, data.contextPath.isNull() ? null : data);
    }

    public boolean upgrade(FilterChainContext ctx, HttpContent requestContent) throws IOException {
        return this.upgrade(ctx, requestContent, null);
    }

    public boolean upgrade(FilterChainContext ctx, HttpContent requestContent, Mapper mapper) throws IOException {
        HttpRequestPacket request = (HttpRequestPacket)requestContent.getHttpHeader();
        WebSocketApplicationReg reg = WebSocketEngine.getEngine().getApplication(request, mapper);
        WebSocket socket = null;
        try {
            if (reg != null) {
                ProtocolHandler protocolHandler = WebSocketEngine.loadHandler(request.getHeaders());
                if (protocolHandler == null) {
                    this.handleUnsupportedVersion(ctx, request);
                    return false;
                }
                final Connection connection = ctx.getConnection();
                protocolHandler.setFilterChainContext(ctx);
                protocolHandler.setConnection(connection);
                protocolHandler.setMappingData(reg.mappingData);
                ctx.setMessage(null);
                WebSocketApplication app = reg.app;
                socket = app.createSocket(protocolHandler, request, app);
                WebSocketHolder holder = WebSocketHolder.set(connection, protocolHandler, socket);
                holder.application = app;
                protocolHandler.handshake(ctx, app, requestContent);
                request.getConnection().addCloseListener((CloseListener)new GenericCloseListener(){

                    public void onClosed(Closeable closeable, CloseType type) throws IOException {
                        WebSocket webSocket = WebSocketHolder.getWebSocket(connection);
                        webSocket.close();
                        webSocket.onClose(new ClosingFrame(1001, "Close detected on connection"));
                    }
                });
                socket.onConnect();
                return true;
            }
        }
        catch (HandshakeException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            if (socket != null) {
                socket.close();
            }
            throw e;
        }
        return false;
    }

    public static ProtocolHandler loadHandler(MimeHeaders headers) {
        for (Version version : Version.values()) {
            if (!version.validate(headers)) continue;
            return version.createHandler(false);
        }
        return null;
    }

    public synchronized void register(String contextPath, String urlPattern, WebSocketApplication app) {
        String contextPathLocal = WebSocketEngine.getContextPath(contextPath);
        this.mapper.addContext("localhost", contextPathLocal, (Object)app, null, null);
        this.mapper.addWrapper("localhost", contextPathLocal, urlPattern, (Object)app);
        this.applicationMap.put(app, contextPathLocal + '|' + urlPattern);
        if (this.contextApplications.containsKey(contextPathLocal)) {
            this.contextApplications.get(contextPathLocal).add(app);
        } else {
            ArrayList<WebSocketApplication> apps = new ArrayList<WebSocketApplication>(4);
            apps.add(app);
            this.contextApplications.put(contextPathLocal, apps);
        }
    }

    @Deprecated
    public synchronized void register(WebSocketApplication app) {
        this.applications.add(app);
    }

    public synchronized void unregister(WebSocketApplication app) {
        String pattern = this.applicationMap.remove(app);
        if (pattern != null) {
            String[] parts = pattern.split("\\|");
            this.mapper.removeWrapper("localhost", parts[0], parts[1]);
            List<WebSocketApplication> apps = this.contextApplications.get(parts[0]);
            apps.remove(app);
            if (apps.isEmpty()) {
                this.mapper.removeContext("localhost", parts[0]);
            }
            return;
        }
        this.applications.remove(app);
    }

    public synchronized void unregisterAll() {
        this.applicationMap.clear();
        this.contextApplications.clear();
        this.applications.clear();
        this.mapper = new Mapper();
        this.mapper.setDefaultHostName("localhost");
    }

    private void handleUnsupportedVersion(FilterChainContext ctx, HttpRequestPacket request) throws IOException {
        this.unsupportedVersionsResponseBuilder.requestPacket(request);
        ctx.write((Object)this.unsupportedVersionsResponseBuilder.build());
    }

    private static String getContextPath(String mapping) {
        String ctx = "";
        int slash = mapping.indexOf("/", 1);
        ctx = slash != -1 ? mapping.substring(0, slash) : mapping;
        if (ctx.startsWith("/*.") || ctx.startsWith("*.")) {
            ctx = ctx.indexOf("/") == ctx.lastIndexOf("/") ? "" : ctx.substring(1);
        }
        if (ctx.startsWith("/*") || ctx.startsWith("*")) {
            ctx = "";
        }
        if (ctx.equals("/")) {
            ctx = "";
        }
        return ctx;
    }

    private static class WebSocketApplicationReg {
        private final WebSocketApplication app;
        private final WebSocketMappingData mappingData;

        public WebSocketApplicationReg(WebSocketApplication app, WebSocketMappingData mappingData) {
            this.app = app;
            this.mappingData = mappingData;
        }
    }
}

