/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.websockets.WebSocketAddOn;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketEngine;

public class WebSocketServer {
    private static final Logger logger = Grizzly.logger(WebSocketServer.class);
    private static final Object SYNC = new Object();
    private HttpServer httpServer;

    protected WebSocketServer() {
    }

    public WebSocketServer(int port) {
        this("0.0.0.0", new PortRange(port));
    }

    protected WebSocketServer(String host, PortRange portRange) {
        NetworkListener networkListener = new NetworkListener("WebSocket NetworkListener", host, portRange);
        networkListener.setMaxPendingBytes(-1);
        networkListener.registerAddOn((AddOn)new WebSocketAddOn());
        this.httpServer = new HttpServer();
        ServerConfiguration config = this.httpServer.getServerConfiguration();
        config.addHttpHandler((HttpHandler)new StaticHttpHandler(new String[]{"."}), new String[]{"/"});
        config.setHttpServerName("WebSocket Server");
        config.setName("WebSocket Server");
        this.httpServer.addListener(networkListener);
    }

    public static WebSocketServer createSimpleServer(int port) {
        return WebSocketServer.createServer(port);
    }

    public static WebSocketServer createServer(int port) {
        return WebSocketServer.createServer("0.0.0.0", new PortRange(port));
    }

    public static WebSocketServer createServer(PortRange range) {
        return WebSocketServer.createServer("0.0.0.0", range);
    }

    public static WebSocketServer createServer(SocketAddress socketAddress) {
        InetSocketAddress inetAddr = (InetSocketAddress)socketAddress;
        return WebSocketServer.createServer(inetAddr.getHostName(), inetAddr.getPort());
    }

    public static WebSocketServer createServer(String host, int port) {
        return WebSocketServer.createServer(host, new PortRange(port));
    }

    public static WebSocketServer createServer(String host, PortRange range) {
        return new WebSocketServer(host, range);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        Object object = SYNC;
        synchronized (object) {
            this.httpServer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = SYNC;
        synchronized (object) {
            WebSocketEngine.getEngine().unregisterAll();
            this.httpServer.stop();
        }
    }

    public void register(String name, WebSocketApplication application) {
        WebSocketEngine.getEngine().register(name, application);
    }
}

