/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets.frametypes;

import java.io.UnsupportedEncodingException;
import org.glassfish.grizzly.websockets.BaseFrameType;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.FramingException;
import org.glassfish.grizzly.websockets.WebSocket;

public class TextFrameType
extends BaseFrameType {
    @Override
    public void setPayload(DataFrame frame, byte[] data) {
        try {
            frame.setPayload(new String(data, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new FramingException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] getBytes(DataFrame dataFrame) {
        try {
            return dataFrame.getTextPayload().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new FramingException(e.getMessage(), e);
        }
    }

    @Override
    public void respond(WebSocket socket, DataFrame frame) {
        if (frame.isLast()) {
            socket.onMessage(frame.getTextPayload());
        } else {
            socket.onFragment(frame.isLast(), frame.getTextPayload());
        }
    }
}

