/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets.draft06;

import java.io.UnsupportedEncodingException;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.FrameType;
import org.glassfish.grizzly.websockets.FramingException;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.glassfish.grizzly.websockets.frametypes.ClosingFrameType;

public class ClosingFrame
extends DataFrame {
    public static final byte[] EMPTY_BYTES = new byte[0];
    private int code;

    public ClosingFrame(int code, String reason) {
        super((FrameType)new ClosingFrameType(), reason, true);
        this.code = code;
    }

    public ClosingFrame(byte[] data) {
        super((FrameType)new ClosingFrameType(), data);
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public void setPayload(byte[] bytes) {
        if (bytes.length > 0) {
            this.code = (int)WebSocketEngine.toLong(bytes, 0, 2);
            if (bytes.length > 2) {
                try {
                    this.setPayload(new String(bytes, 2, bytes.length - 2, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new FramingException(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.code == -1) {
            return EMPTY_BYTES;
        }
        byte[] bytes = WebSocketEngine.toArray(this.code);
        byte[] reasonBytes = super.getBytes() == null ? EMPTY_BYTES : super.getBytes();
        byte[] frameBytes = new byte[2 + reasonBytes.length];
        System.arraycopy(bytes, bytes.length - 2, frameBytes, 0, 2);
        System.arraycopy(reasonBytes, 0, frameBytes, 2, reasonBytes.length);
        return frameBytes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClosingFrame");
        sb.append("{code=").append(this.code);
        sb.append(", payload=").append(this.getTextPayload() == null ? null : "'" + this.getTextPayload() + "'");
        sb.append('}');
        return sb.toString();
    }
}

