/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets.draft76;

import java.io.ByteArrayOutputStream;
import java.net.URI;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.FrameType;
import org.glassfish.grizzly.websockets.FramingException;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocketException;
import org.glassfish.grizzly.websockets.draft76.Draft76FrameType;
import org.glassfish.grizzly.websockets.draft76.HandShake76;

public class Draft76Handler
extends ProtocolHandler {
    public Draft76Handler() {
        super(false);
    }

    @Override
    public byte[] frame(DataFrame frame) {
        return frame.getType().getBytes(frame);
    }

    @Override
    public DataFrame parse(Buffer buffer) {
        if (buffer.remaining() < 2) {
            return null;
        }
        byte b = buffer.get();
        DataFrame frame = null;
        block0 : switch (b) {
            case 0: {
                ByteArrayOutputStream raw = new ByteArrayOutputStream();
                while (buffer.hasRemaining()) {
                    b = buffer.get();
                    if (b == -1) {
                        frame = new DataFrame((FrameType)Draft76FrameType.TEXT, raw.toByteArray());
                        break block0;
                    }
                    raw.write(b);
                }
                break;
            }
            case -1: {
                frame = new DataFrame((FrameType)Draft76FrameType.CLOSING, new byte[]{b, buffer.get()});
                break;
            }
            default: {
                throw new FramingException("Unknown frame type: " + b);
            }
        }
        return frame;
    }

    @Override
    protected HandShake createHandShake(HttpContent requestContent) {
        return new HandShake76(requestContent);
    }

    @Override
    protected HandShake createHandShake(URI uri) {
        return new HandShake76(uri);
    }

    @Override
    public GrizzlyFuture<DataFrame> send(String data) {
        return this.send(new DataFrame((FrameType)Draft76FrameType.TEXT, data));
    }

    @Override
    public GrizzlyFuture<DataFrame> close(int code, String reason) {
        return this.send(new DataFrame((FrameType)Draft76FrameType.CLOSING, (String)null, true));
    }

    @Override
    public GrizzlyFuture<DataFrame> send(byte[] data) {
        throw new WebSocketException("Binary data not supported in draft 76");
    }

    @Override
    public GrizzlyFuture<DataFrame> stream(boolean last, byte[] bytes, int off, int len) {
        throw new WebSocketException("Streaming not supported in draft 76");
    }

    @Override
    public GrizzlyFuture<DataFrame> stream(boolean last, String data) {
        throw new WebSocketException("Streaming not supported in draft 76");
    }

    @Override
    protected boolean isControlFrame(byte opcode) {
        return false;
    }
}

