/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets.draft06;

import java.net.URI;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.FrameType;
import org.glassfish.grizzly.websockets.FramingException;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.Masker;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.draft06.HandShake06;
import org.glassfish.grizzly.websockets.frametypes.BinaryFrameType;
import org.glassfish.grizzly.websockets.frametypes.ClosingFrameType;
import org.glassfish.grizzly.websockets.frametypes.ContinuationFrameType;
import org.glassfish.grizzly.websockets.frametypes.PingFrameType;
import org.glassfish.grizzly.websockets.frametypes.PongFrameType;
import org.glassfish.grizzly.websockets.frametypes.TextFrameType;

public class Draft06Handler
extends ProtocolHandler {
    public Draft06Handler() {
        super(false);
    }

    public Draft06Handler(boolean maskData) {
        super(maskData);
    }

    @Override
    protected HandShake createHandShake(HttpContent requestContent) {
        return new HandShake06((HttpRequestPacket)requestContent.getHttpHeader());
    }

    @Override
    protected HandShake createHandShake(URI uri) {
        return new HandShake06(uri);
    }

    @Override
    public byte[] frame(DataFrame frame) {
        byte opcode = this.checkForLastFrame(frame, this.getOpcode(frame.getType()));
        byte[] payloadBytes = frame.getBytes();
        byte[] lengthBytes = this.encodeLength(payloadBytes.length);
        int packetLength = 1 + lengthBytes.length;
        byte[] packet = new byte[packetLength + payloadBytes.length];
        packet[0] = opcode;
        System.arraycopy(lengthBytes, 0, packet, 1, lengthBytes.length);
        System.arraycopy(payloadBytes, 0, packet, packetLength, payloadBytes.length);
        if (this.maskData) {
            packet = new Masker().maskAndPrepend(packet);
        }
        return packet;
    }

    @Override
    public DataFrame parse(Buffer buffer) {
        long length;
        byte lengthCode;
        Masker masker = new Masker(buffer);
        if (!this.maskData) {
            if (buffer.remaining() < 4) {
                return null;
            }
            masker.readMask();
        }
        if (buffer.remaining() < 2) {
            return null;
        }
        byte opcode = masker.unmask();
        boolean finalFragment = (opcode & 0x80) == 128;
        opcode = (byte)(opcode & 0x7F);
        FrameType type = this.valueOf(this.inFragmentedType, opcode);
        if (!finalFragment) {
            if (this.inFragmentedType == 0) {
                this.inFragmentedType = opcode;
            }
        } else {
            this.inFragmentedType = 0;
        }
        if ((lengthCode = masker.unmask()) <= 125) {
            length = lengthCode;
        } else {
            int lengthBytes;
            int n = lengthBytes = lengthCode == 126 ? 2 : 8;
            if (buffer.remaining() < lengthBytes) {
                return null;
            }
            length = this.decodeLength(masker.unmask(lengthBytes));
        }
        if ((long)buffer.remaining() < length) {
            return null;
        }
        byte[] data = masker.unmask((int)length);
        if ((long)data.length != length) {
            throw new FramingException(String.format("Data read (%s) is not the expected size (%s)", data.length, length));
        }
        return type.create(finalFragment, data);
    }

    @Override
    protected boolean isControlFrame(byte opcode) {
        return opcode == 1 || opcode == 2 || opcode == 3;
    }

    private byte getOpcode(FrameType type) {
        if (type instanceof ClosingFrameType) {
            return 1;
        }
        if (type instanceof PingFrameType) {
            return 2;
        }
        if (type instanceof PongFrameType) {
            return 3;
        }
        if (type instanceof TextFrameType) {
            return 4;
        }
        if (type instanceof BinaryFrameType) {
            return 5;
        }
        throw new FramingException("Unknown frame type: " + type.getClass().getName());
    }

    private FrameType valueOf(byte fragmentType, byte value) {
        int opcode = value & 0xF;
        switch (opcode & 0xF) {
            case 0: {
                return new ContinuationFrameType((fragmentType & 4) == 4);
            }
            case 1: {
                return new ClosingFrameType();
            }
            case 2: {
                return new PingFrameType();
            }
            case 3: {
                return new PongFrameType();
            }
            case 4: {
                return new TextFrameType();
            }
            case 5: {
                return new BinaryFrameType();
            }
        }
        throw new FramingException("Unknown frame type: " + value);
    }
}

