/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.draft06.Draft06Handler;
import org.glassfish.grizzly.websockets.draft07.Draft07Handler;
import org.glassfish.grizzly.websockets.draft08.Draft08Handler;

public enum Version {
    DRAFT06{

        @Override
        public ProtocolHandler createHandler(boolean mask) {
            return new Draft06Handler(mask);
        }

        @Override
        public boolean validate(MimeHeaders headers) {
            return "6".equals(headers.getHeader("Sec-WebSocket-Version"));
        }
    }
    ,
    DRAFT07{

        @Override
        public ProtocolHandler createHandler(boolean mask) {
            return new Draft07Handler(mask);
        }

        @Override
        public boolean validate(MimeHeaders headers) {
            return "7".equals(headers.getHeader("Sec-WebSocket-Version"));
        }
    }
    ,
    DRAFT08{

        @Override
        public ProtocolHandler createHandler(boolean mask) {
            return new Draft08Handler(mask);
        }

        @Override
        public boolean validate(MimeHeaders headers) {
            return "8".equals(headers.getHeader("Sec-WebSocket-Version"));
        }
    };


    public abstract ProtocolHandler createHandler(boolean var1);

    public abstract boolean validate(MimeHeaders var1);

    public String toString() {
        return this.name();
    }

    public boolean isFragmentationSupported() {
        return true;
    }
}

