/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.UnsupportedEncodingException;
import org.glassfish.grizzly.websockets.FrameType;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketEngine;

public class DataFrame {
    private String payload;
    private byte[] bytes;
    private final FrameType type;
    private boolean last;

    public DataFrame(FrameType type, String data) {
        this(type, data, true);
    }

    public DataFrame(FrameType type, String data, boolean fin) {
        this.type = type;
        this.setPayload(data);
        this.last = fin;
    }

    public DataFrame(FrameType type, byte[] data) {
        this(type, data, true);
    }

    public DataFrame(FrameType type, byte[] data, boolean fin) {
        this.type = type;
        type.setPayload(this, data);
        this.last = fin;
    }

    public FrameType getType() {
        return this.type;
    }

    public String getTextPayload() {
        return this.payload;
    }

    public final void setPayload(String payload) {
        this.payload = payload;
        try {
            this.bytes = payload != null ? payload.getBytes("UTF-8") : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void setPayload(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void respond(WebSocket socket) {
        this.getType().respond(socket, this);
    }

    public String toString() {
        return "DataFrame" + "{" + "last=" + this.last + ", type=" + this.type.getClass().getSimpleName() + ", payload='" + this.getTextPayload() + '\'' + ", bytes=" + WebSocketEngine.toString(this.bytes) + '}';
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }
}

