/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets.draft76;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Random;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.memory.HeapBuffer;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketException;
import org.glassfish.grizzly.websockets.draft76.SecKey;

public class HandShake76
extends HandShake {
    public static final String SEC_WS_KEY1_HEADER = "Sec-WebSocket-Key1";
    public static final String SEC_WS_KEY2_HEADER = "Sec-WebSocket-Key2";
    public static final String SERVER_SEC_WS_ORIGIN_HEADER = "Sec-WebSocket-Origin";
    public static final String SERVER_SEC_WS_LOCATION_HEADER = "Sec-WebSocket-Location";
    private static final int KEY3_SIZE = 8;
    private final SecKey key1;
    private final SecKey key2;
    private final byte[] key3;
    private byte[] serverSecKey;
    private static final Random random = new Random();

    public HandShake76(URI uri) {
        super(uri);
        if (this.isSecure() && this.getPort() != 443 || !this.isSecure() && this.getPort() != 80) {
            this.setServerHostName(this.getServerHostName() + ":" + this.getPort());
        }
        this.key1 = SecKey.generateSecKey();
        this.key2 = SecKey.generateSecKey();
        this.key3 = new byte[8];
        random.nextBytes(this.key3);
    }

    public HandShake76(HttpContent message) {
        super((HttpRequestPacket)message.getHttpHeader());
        HttpRequestPacket request = (HttpRequestPacket)message.getHttpHeader();
        MimeHeaders headers = request.getHeaders();
        this.key1 = SecKey.parse(headers.getHeader(SEC_WS_KEY1_HEADER));
        this.key2 = SecKey.parse(headers.getHeader(SEC_WS_KEY2_HEADER));
        this.key3 = new byte[8];
        message.getContent().get(this.key3);
        this.serverSecKey = this.key3 == null ? null : SecKey.generateServerKey(this.key1, this.key2, this.key3);
    }

    @Override
    public HttpContent composeHeaders() {
        HttpContent httpContent = super.composeHeaders();
        HttpHeader header = httpContent.getHttpHeader();
        header.addHeader("Origin", this.getOrigin());
        header.addHeader(SEC_WS_KEY1_HEADER, this.key1.getSecKey());
        header.addHeader(SEC_WS_KEY2_HEADER, this.key2.getSecKey());
        return httpContent;
    }

    @Override
    public void initiate(FilterChainContext ctx) throws IOException {
        ctx.write((Object)this.composeHeaders());
        ctx.write((Object)HeapBuffer.wrap((byte[])this.key3));
    }

    @Override
    public void validateServerResponse(HttpResponsePacket headers) {
        super.validateServerResponse(headers);
        String serverLocation = headers.getHeader(SERVER_SEC_WS_LOCATION_HEADER);
        if (!this.getLocation().equals(serverLocation)) {
            throw new HandshakeException(String.format("Location field from server doesn't match: client '%s' vs. server '%s'", this.getLocation(), serverLocation));
        }
        byte[] clientKey = SecKey.generateServerKey(this.key1, this.key2, this.key3);
        Object buffer = null;
        byte[] serverKey = new byte[16];
        buffer.get(serverKey);
        if (!Arrays.equals(clientKey, serverKey)) {
            throw new HandshakeException(String.format("Security keys do not match: client '%s' vs. server '%s'", Arrays.toString(clientKey), Arrays.toString(serverKey)));
        }
    }

    @Override
    public void respond(FilterChainContext ctx, WebSocketApplication app, HttpResponsePacket response) {
        super.respond(ctx, app, response);
        HeapBuffer buffer = HeapBuffer.wrap((byte[])this.serverSecKey);
        try {
            ctx.write((Object)buffer);
        }
        catch (IOException e) {
            throw new WebSocketException(e.getMessage(), e);
        }
    }

    @Override
    public void setHeaders(HttpResponsePacket response) {
        response.setReasonPhrase("WebSocket Protocol Handshake");
        response.setHeader("Upgrade", "WebSocket");
        response.setHeader(SERVER_SEC_WS_LOCATION_HEADER, this.getLocation());
        response.setHeader(SERVER_SEC_WS_ORIGIN_HEADER, this.getOrigin());
    }
}

