/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets.draft76;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.FrameType;
import org.glassfish.grizzly.websockets.FramingException;
import org.glassfish.grizzly.websockets.WebSocket;

enum Draft76FrameType implements FrameType
{
    TEXT{

        @Override
        public void setPayload(DataFrame frame, byte[] data) {
            try {
                frame.setPayload(new String(data, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new FramingException(e.getMessage(), e);
            }
        }

        @Override
        public byte[] getBytes(DataFrame frame) {
            byte[] data = frame.getBytes();
            ByteArrayOutputStream out = new ByteArrayOutputStream(data.length + 2);
            out.write(0);
            out.write(data, 0, data.length);
            out.write(-1);
            return out.toByteArray();
        }

        @Override
        public void respond(WebSocket socket, DataFrame frame) {
            socket.onMessage(frame.getTextPayload());
        }
    }
    ,
    CLOSING{

        @Override
        public void setPayload(DataFrame frame, byte[] data) {
            frame.setPayload(data);
        }

        @Override
        public byte[] getBytes(DataFrame frame) {
            return new byte[]{-1, 0};
        }

        @Override
        public void respond(WebSocket socket, DataFrame frame) {
            socket.close();
        }
    };


    @Override
    public DataFrame create(boolean fin, byte[] data) {
        return new DataFrame((FrameType)this, data);
    }
}

