/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Appendable;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.FramingException;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketEngine;

public class WebSocketFilter
extends BaseFilter {
    private static final Logger logger = Grizzly.logger(WebSocketFilter.class);
    private static final Random random = new Random();

    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        logger.log(Level.FINEST, "handleConnect");
        Connection connection = ctx.getConnection();
        if (!this.webSocketInProgress(connection)) {
            return ctx.getInvokeAction();
        }
        WebSocketEngine.getEngine().getWebSocketHolder((Connection)connection).handshake.initiate(ctx);
        ctx.flush(null);
        return ctx.getInvokeAction();
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        WebSocket ws;
        Connection connection = ctx.getConnection();
        if (this.webSocketInProgress(connection) && (ws = this.getWebSocket(connection)) != null) {
            ws.close();
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        HttpContent message = (HttpContent)ctx.getMessage();
        HttpHeader header = message.getHttpHeader();
        WebSocketEngine.WebSocketHolder holder = WebSocketEngine.getEngine().getWebSocketHolder(connection);
        WebSocket ws = this.getWebSocket(connection);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "handleRead websocket: {0} content-size={1} headers=\n{2}", new Object[]{ws, message.getContent().remaining(), header});
        }
        if (ws == null || !ws.isConnected()) {
            if (!this.webSocketInProgress(connection) && !"websocket".equalsIgnoreCase(header.getUpgrade())) {
                return ctx.getInvokeAction();
            }
            return this.handleHandshake(ctx, message);
        }
        if (message.getContent().hasRemaining()) {
            Buffer buffer = message.getContent();
            message.recycle();
            try {
                while (buffer != null && buffer.hasRemaining()) {
                    DataFrame result;
                    if (holder.buffer != null) {
                        buffer = Buffers.appendBuffers((MemoryManager)ctx.getMemoryManager(), (Buffer)holder.buffer, (Buffer)buffer);
                        holder.buffer = null;
                    }
                    if ((result = holder.handler.unframe(buffer)) == null) {
                        holder.buffer = buffer;
                        break;
                    }
                    result.respond(holder.webSocket);
                }
            }
            catch (FramingException e) {
                if (e.getCode() != -1) {
                    holder.webSocket.close(e.getCode(), e.getMessage());
                }
                holder.webSocket.close();
            }
        }
        return ctx.getStopAction();
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        WebSocket websocket = this.getWebSocket(ctx.getConnection());
        if (websocket != null) {
            DataFrame frame = (DataFrame)ctx.getMessage();
            WebSocketEngine.WebSocketHolder holder = WebSocketEngine.getEngine().getWebSocketHolder(ctx.getConnection());
            Buffer wrap = Buffers.wrap((MemoryManager)ctx.getMemoryManager(), (byte[])holder.handler.frame(frame));
            ctx.setMessage((Object)wrap);
            ctx.flush(null);
        }
        return ctx.getInvokeAction();
    }

    private NextAction handleHandshake(FilterChainContext ctx, HttpContent content) throws IOException {
        return content.getHttpHeader().isRequest() ? this.handleServerHandshake(ctx, content) : this.handleClientHandShake(ctx, content);
    }

    private NextAction handleClientHandShake(FilterChainContext ctx, HttpContent content) {
        WebSocketEngine.WebSocketHolder holder = WebSocketEngine.getEngine().getWebSocketHolder(ctx.getConnection());
        holder.handshake.validateServerResponse((HttpResponsePacket)content.getHttpHeader());
        holder.webSocket.onConnect();
        return ctx.getStopAction((Appendable)content);
    }

    private NextAction handleServerHandshake(FilterChainContext ctx, HttpContent requestContent) throws IOException {
        HttpRequestPacket request = (HttpRequestPacket)requestContent.getHttpHeader();
        try {
            WebSocketEngine.getEngine().upgrade(ctx, requestContent);
        }
        catch (HandshakeException e) {
            ctx.write((Object)this.composeHandshakeError(request, e));
        }
        ctx.flush(null);
        return ctx.getStopAction();
    }

    private WebSocket getWebSocket(Connection connection) {
        return WebSocketEngine.getEngine().getWebSocket(connection);
    }

    private boolean webSocketInProgress(Connection connection) {
        return WebSocketEngine.getEngine().webSocketInProgress(connection);
    }

    private HttpResponsePacket composeHandshakeError(HttpRequestPacket request, HandshakeException e) {
        HttpResponsePacket response = request.getResponse();
        response.setStatus(e.getCode());
        response.setReasonPhrase(e.getMessage());
        return response;
    }
}

