/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.HttpClientFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.DefaultWebSocket;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.Version;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketAdapter;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.glassfish.grizzly.websockets.WebSocketException;
import org.glassfish.grizzly.websockets.WebSocketFilter;
import org.glassfish.grizzly.websockets.WebSocketListener;

public class WebSocketClient
extends DefaultWebSocket {
    private static final Logger logger = Logger.getLogger("websocket");
    private Version version;
    private final URI address;
    private final ExecutorService executorService = Executors.newFixedThreadPool(2);
    protected TCPNIOTransport transport;

    public WebSocketClient(String uri, WebSocketListener ... listeners) {
        this(uri, WebSocketEngine.DEFAULT_VERSION, listeners);
    }

    public WebSocketClient(String uri, Version version, WebSocketListener ... listeners) {
        super(version.createHandler(true), listeners);
        this.version = version;
        try {
            this.address = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new WebSocketException(e.getMessage(), e);
        }
        this.add(new WebSocketCloseAdapter());
    }

    public URI getAddress() {
        return this.address;
    }

    public void execute(Runnable runnable) {
        this.executorService.submit(runnable);
    }

    public WebSocket connect() {
        return this.connect(WebSocketEngine.DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    public WebSocket connect(long timeout, TimeUnit unit) {
        try {
            this.transport = TCPNIOTransportBuilder.newInstance().build();
            this.transport.start();
            TCPNIOConnectorHandler connectorHandler = new TCPNIOConnectorHandler(this.transport){

                protected void preConfigure(Connection conn) {
                    super.preConfigure(conn);
                    WebSocketClient.this.protocolHandler.setConnection(conn);
                    WebSocketEngine.WebSocketHolder holder = WebSocketEngine.getEngine().setWebSocketHolder(conn, WebSocketClient.this.protocolHandler, WebSocketClient.this);
                    holder.handshake = WebSocketClient.this.protocolHandler.createHandShake(WebSocketClient.this.address);
                }
            };
            final CountDownLatch latch = new CountDownLatch(1);
            this.add(new WebSocketAdapter(){

                @Override
                public void onConnect(WebSocket socket) {
                    super.onConnect(socket);
                    latch.countDown();
                }
            });
            connectorHandler.setProcessor(WebSocketClient.createFilterChain());
            connectorHandler.connect((SocketAddress)new InetSocketAddress(this.address.getHost(), this.address.getPort())).markForRecycle(false);
            latch.await(timeout, unit);
            return this;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HandshakeException(e.getMessage());
        }
    }

    private static Processor createFilterChain() {
        FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
        clientFilterChainBuilder.add((Filter)new TransportFilter());
        clientFilterChainBuilder.add((Filter)new HttpClientFilter());
        clientFilterChainBuilder.add((Filter)new WebSocketFilter());
        return clientFilterChainBuilder.build();
    }

    private class WebSocketCloseAdapter
    extends WebSocketAdapter {
        private WebSocketCloseAdapter() {
        }

        @Override
        public void onClose(WebSocket socket, DataFrame frame) {
            super.onClose(socket, frame);
            if (WebSocketClient.this.transport != null) {
                try {
                    WebSocketClient.this.transport.stop();
                }
                catch (IOException e) {
                    logger.log(Level.INFO, e.getMessage(), e);
                }
            }
        }
    }
}

