/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.SecKey;
import org.glassfish.grizzly.websockets.WebSocketHandshake;

public class ServerHandshake
extends WebSocketHandshake {
    private SecKey serverSecKey;
    private String enabledExtensions;
    private String enabledProtocols;

    public ServerHandshake(HttpRequestPacket httpHeader) throws HandshakeException {
        super(httpHeader.isSecure(), httpHeader.getRequestURI());
        MimeHeaders headers = httpHeader.getHeaders();
        this.determineHostAndPort(headers);
        this.checkForHeader(headers, "Upgrade", "WebSocket");
        this.checkForHeader(headers, "Connection", "Upgrade");
        this.setSubProtocol(this.split(headers.getHeader("Sec-WebSocket-Protocol")));
        this.setExtensions(this.split(headers.getHeader("Sec-WebSocket-Extensions")));
        this.serverSecKey = SecKey.generateServerKey(new SecKey(headers.getHeader("Sec-WebSocket-Key")));
        this.setOrigin(this.readHeader(headers, "Sec-WebSocket-Origin"));
        this.setLocation(this.buildLocation(this.isSecure()));
        if (this.getServerHostName() == null) {
            throw new HandshakeException("Missing host name required for WebSocket negotiation");
        }
    }

    private String[] split(String header) {
        return header == null ? null : header.split(";");
    }

    private void checkForHeader(MimeHeaders headers, String header, String validValue) {
        String value = headers.getHeader(header);
        if (!validValue.equalsIgnoreCase(value)) {
            throw new HandshakeException(String.format("Invalid %s header returned: '%s'", header, value));
        }
    }

    final String readHeader(MimeHeaders headers, String name) {
        DataChunk value = headers.getValue(name);
        return value == null ? null : value.toString();
    }

    private void determineHostAndPort(MimeHeaders headers) {
        int i;
        String header = this.readHeader(headers, "host");
        int n = i = header == null ? -1 : header.indexOf(":");
        if (i == -1) {
            this.setServerHostName(header);
            this.setPort(80);
        } else {
            this.setServerHostName(header.substring(0, i));
            this.setPort(Integer.parseInt(header.substring(i + 1)));
        }
    }

    public String getEnabledExtensions() {
        return this.enabledExtensions;
    }

    public void setEnabledExtensions(String[] enabledExtensions) {
        this.enabledExtensions = enabledExtensions != null ? this.join(enabledExtensions) : null;
    }

    public String getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols != null ? this.join(enabledProtocols) : null;
    }

    public HttpContent respond(HttpRequestPacket request) {
        HttpResponsePacket response = request.getResponse();
        response.setStatus(101);
        response.setReasonPhrase("Switching Protocols");
        response.setProtocol(Protocol.HTTP_1_1);
        response.setUpgrade("WebSocket");
        response.setHeader("Connection", "Upgrade");
        response.setHeader("Sec-WebSocket-Accept", this.serverSecKey.getSecKey());
        if (this.getEnabledProtocols() != null) {
            response.setHeader("Sec-WebSocket-Protocol", this.join(this.getSubProtocol()));
        }
        if (this.getEnabledExtensions() != null) {
            response.setHeader("Sec-WebSocket-Extensions", this.join(this.getSubProtocol()));
        }
        return HttpContent.builder((HttpHeader)response).build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ServerHandshake");
        sb.append("{enabledExtensions='").append(this.enabledExtensions).append('\'');
        sb.append(", serverSecKey=").append(this.serverSecKey);
        sb.append(", enabledProtocols='").append(this.enabledProtocols).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

