/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets.frame;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.NIOTransportBuilder;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.websockets.frame.Frame;
import org.glassfish.grizzly.websockets.frame.ParseResult;

class FixedLengthFrame
extends Frame {
    private static final int[][] MASKS = new int[][]{{0x70000000, 28}, {0xFE00000, 21}, {2080768, 14}, {16256, 7}, {127, 0}};
    private ParseState parseState = ParseState.TYPE;
    private int contentLengthRemaining;

    public FixedLengthFrame(int type, Buffer buffer) {
        super(type, buffer);
    }

    @Override
    public final boolean isClose() {
        return this.type == 255 && (this.buffer == null || !this.buffer.hasRemaining());
    }

    @Override
    public Buffer serialize() {
        MemoryManager mm = NIOTransportBuilder.DEFAULT_MEMORY_MANAGER;
        Buffer startBuffer = mm.allocate(6);
        startBuffer.put((byte)(this.type & 0xFF));
        int length = this.buffer != null ? this.buffer.remaining() : 0;
        FixedLengthFrame.encodeLength(length, startBuffer);
        startBuffer.trim();
        return Buffers.appendBuffers((MemoryManager)mm, (Buffer)startBuffer, (Buffer)this.buffer);
    }

    @Override
    public ParseResult parse(Buffer buffer) {
        MemoryManager mm = NIOTransportBuilder.DEFAULT_MEMORY_MANAGER;
        switch (this.parseState) {
            case TYPE: {
                if (!buffer.hasRemaining()) {
                    return ParseResult.create(false, null);
                }
                this.type = buffer.get() & 0xFF;
                this.parseState = ParseState.LENGTH;
            }
            case LENGTH: {
                while (buffer.hasRemaining()) {
                    int gotByte = buffer.get() & 0xFF;
                    int sevenBits = gotByte & 0x7F;
                    this.contentLengthRemaining = this.contentLengthRemaining << 7 | sevenBits;
                    if (sevenBits != gotByte) continue;
                    this.parseState = ParseState.CONTENT;
                    break;
                }
                if (this.parseState == ParseState.LENGTH) {
                    return ParseResult.create(false, null);
                }
            }
            case CONTENT: {
                Buffer remainder = null;
                if (buffer.remaining() > this.contentLengthRemaining) {
                    int remainderLen = buffer.remaining() - this.contentLengthRemaining;
                    remainder = buffer.slice(buffer.limit() - remainderLen, buffer.limit());
                    buffer.limit(buffer.limit() - remainderLen);
                }
                this.contentLengthRemaining -= buffer.remaining();
                this.buffer = Buffers.appendBuffers((MemoryManager)mm, (Buffer)this.buffer, (Buffer)buffer);
                buffer = remainder;
                if (this.contentLengthRemaining > 0) {
                    return ParseResult.create(false, null);
                }
                this.parseState = ParseState.DONE;
            }
            case DONE: {
                return ParseResult.create(true, buffer);
            }
        }
        throw new IllegalStateException();
    }

    private static void encodeLength(int length, Buffer startBuffer) {
        boolean written = false;
        for (int i = 0; i < MASKS.length; ++i) {
            int sevenBits = (length & MASKS[i][0]) >> MASKS[i][1];
            if (i == MASKS.length - 1) {
                startBuffer.put((byte)sevenBits);
                continue;
            }
            if (!written && sevenBits == 0) continue;
            written = true;
            startBuffer.put((byte)(sevenBits |= 0x80));
        }
    }

    private static enum ParseState {
        TYPE,
        LENGTH,
        CONTENT,
        DONE;

    }
}

