/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketHandler;
import org.glassfish.grizzly.websockets.WebSocketMeta;
import org.glassfish.grizzly.websockets.frame.Frame;

public class WebSocketBase
implements WebSocket {
    protected final WebSocketMeta meta;
    protected final Connection connection;
    protected final WebSocketHandler<? extends WebSocketBase> handler;
    private Frame parsingFrame;
    private final AtomicBoolean isClosed = new AtomicBoolean();

    public WebSocketBase(Connection connection, WebSocketMeta meta, WebSocketHandler<? extends WebSocketBase> handler) {
        this.connection = connection;
        this.meta = meta;
        this.handler = handler;
    }

    @Override
    public URI getURI() {
        return this.meta.getURI();
    }

    @Override
    public WebSocketMeta getMeta() {
        return this.meta;
    }

    @Override
    public WebSocketHandler getHandler() {
        return this.handler;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public final GrizzlyFuture<Frame> send(Frame frame) throws IOException {
        return this.send(frame, null);
    }

    @Override
    public GrizzlyFuture<Frame> send(Frame frame, CompletionHandler<Frame> completionHandler) throws IOException {
        return this.connection.write((Object)frame, completionHandler);
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed.getAndSet(true)) {
            this.getHandler().onClose(this);
            GrizzlyFuture<Frame> future = this.send(Frame.createCloseFrame());
            try {
                future.get(200L, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection.close();
        }
    }

    @Override
    public boolean isConnected() {
        return !this.isClosed.get();
    }

    Frame getParsingFrame() {
        return this.parsingFrame;
    }

    void setParsingFrame(Frame parsingFrame) {
        this.parsingFrame = parsingFrame;
    }
}

