/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.net.URI;
import org.glassfish.grizzly.http.HttpHeader;

public abstract class WebSocketMeta {
    private final boolean isSecure;
    private final URI uri;
    private final String origin;
    private final String protocol;
    private volatile HttpHeader handshakeHeader;

    public WebSocketMeta(URI uri) {
        this(uri, null, null, null);
    }

    public WebSocketMeta(URI uri, String origin, String protocol, Boolean isSecure) {
        String wsProtocol;
        Boolean isSecureSchema = null;
        if (uri != null && (wsProtocol = uri.getScheme()) != null) {
            boolean isWs = wsProtocol.equals("ws");
            if (!isWs && !wsProtocol.equals("wss")) {
                throw new IllegalStateException("Unexpected WebSockets schema: " + wsProtocol);
            }
            isSecureSchema = !isWs;
        }
        this.uri = uri;
        this.origin = origin != null ? origin : "http://localhost";
        String string = this.protocol = protocol != null ? protocol : null;
        this.isSecure = isSecure != null ? isSecure : (isSecureSchema != null ? isSecureSchema : false);
    }

    public URI getURI() {
        return this.uri;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public HttpHeader getHandshakeHeader() {
        return this.handshakeHeader;
    }

    protected void setHandshakeHeader(HttpHeader httpHeader) {
        this.handshakeHeader = httpHeader;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("uri=").append(this.uri).append(" origin=").append(this.origin).append(" protocol=").append(this.protocol);
        return sb.toString();
    }
}

