/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.HttpClientFilter;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.websockets.ClientWebSocketMeta;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketClientHandler;
import org.glassfish.grizzly.websockets.WebSocketConnectHandler;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.glassfish.grizzly.websockets.WebSocketFilter;

public class WebSocketConnectorHandler {
    private static final Logger logger = Grizzly.logger(WebSocketConnectorHandler.class);
    private final TCPNIOTransport transport;
    private final Processor processor;

    public WebSocketConnectorHandler(TCPNIOTransport transport) {
        this(transport, null);
    }

    public WebSocketConnectorHandler(TCPNIOTransport transport, Processor processor) {
        this.transport = transport;
        this.processor = processor != null ? processor : WebSocketConnectorHandler.createFilterChain();
    }

    public Future<WebSocket> connect(URI uri, WebSocketClientHandler handler) throws IOException, HandshakeException {
        return this.connect(new ClientWebSocketMeta(uri), handler);
    }

    public Future<WebSocket> connect(final ClientWebSocketMeta meta, final WebSocketClientHandler handler) throws IOException, HandshakeException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "connect websocket meta={0}", meta);
        }
        SafeFutureImpl future = SafeFutureImpl.create();
        final WebSocketConnectHandler connectHandler = new WebSocketConnectHandler((FutureImpl<WebSocket>)future);
        final WebSocketEngine engine = WebSocketEngine.getEngine();
        TCPNIOConnectorHandler connectorHandler = new TCPNIOConnectorHandler(this.transport){

            protected void preConfigure(Connection connection) {
                super.preConfigure(connection);
                engine.setClientConnectContext(connection, meta, handler, connectHandler);
            }
        };
        connectorHandler.setProcessor(this.processor);
        URI uri = meta.getURI();
        String host = uri.getHost();
        int port = uri.getPort();
        connectorHandler.connect((SocketAddress)new InetSocketAddress(host, port), (CompletionHandler)connectHandler);
        return future;
    }

    private static Processor createFilterChain() {
        FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
        clientFilterChainBuilder.add((Filter)new TransportFilter());
        clientFilterChainBuilder.add((Filter)new HttpClientFilter());
        clientFilterChainBuilder.add((Filter)new WebSocketFilter());
        return clientFilterChainBuilder.build();
    }
}

