/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.net.URI;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.websockets.SecKey;
import org.glassfish.grizzly.websockets.WebSocketMeta;

public class ClientWebSocketMeta
extends WebSocketMeta {
    private static final Logger logger = Grizzly.logger(ClientWebSocketMeta.class);
    private static final Random random = new Random();
    private final String host;
    private final SecKey key1;
    private final SecKey key2;
    private byte[] key3;

    public ClientWebSocketMeta(URI uri) {
        this(uri, null, null, null, null, null, null, null);
    }

    public ClientWebSocketMeta(URI uri, String origin, String protocol, String host, String key1, String key2, byte[] key3, Boolean isSecure) {
        super(uri, origin != null ? origin : "http://localhost", protocol, isSecure);
        if (uri == null) {
            throw new IllegalArgumentException("URI can not be null");
        }
        String string = this.host = host != null ? host : uri.getHost() + ClientWebSocketMeta.getPort(uri);
        if (key1 == null || key2 == null || key3 == null) {
            GeneratedKeys generatedKeys = ClientWebSocketMeta.generateKeys();
            this.key1 = generatedKeys.getKey1();
            this.key2 = generatedKeys.getKey2();
            this.key3 = generatedKeys.getKey3();
        } else {
            if (key3.length != 8) {
                throw new IllegalArgumentException("key3 length should be 8 bytes");
            }
            SecKey secKey = SecKey.create(key1);
            if (secKey == null) {
                throw new IllegalArgumentException("key1 is not correct: " + key1);
            }
            this.key1 = secKey;
            secKey = SecKey.create(key2);
            if (secKey == null) {
                throw new IllegalArgumentException("key2 is not correct: " + key2);
            }
            this.key2 = secKey;
            this.key3 = key3;
        }
    }

    public String getHost() {
        return this.host;
    }

    public SecKey getKey1() {
        return this.key1;
    }

    public SecKey getKey2() {
        return this.key2;
    }

    public byte[] getKey3() {
        return this.key3;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append(super.toString()).append(" host=").append(this.host).append(" key1=").append(this.key1).append(" key2=").append(this.key2).append(" key3=").append(Arrays.toString(this.key3));
        return sb.toString();
    }

    private static String getPort(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            String schema = uri.getScheme();
            if ("ws".equals(schema) || "wss".equals(schema)) {
                return "";
            }
            throw new IllegalStateException("Unexpected protocol!");
        }
        return ":" + port;
    }

    private static GeneratedKeys generateKeys() {
        SecKey key1 = SecKey.generateSecKey();
        SecKey key2 = SecKey.generateSecKey();
        byte[] key3 = new byte[8];
        random.nextBytes(key3);
        return new GeneratedKeys(key1, key2, key3);
    }

    private static class GeneratedKeys {
        private final SecKey key1;
        private final SecKey key2;
        private final byte[] key3;

        public GeneratedKeys(SecKey key1, SecKey key2, byte[] key3) {
            this.key1 = key1;
            this.key2 = key2;
            this.key3 = key3;
        }

        public SecKey getKey1() {
            return this.key1;
        }

        public SecKey getKey2() {
            return this.key2;
        }

        public byte[] getKey3() {
            return this.key3;
        }
    }
}

