/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.frames;

import java.util.Map;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.memory.MemoryManager;

public abstract class Http2Frame
implements Cacheable {
    public static final int FRAME_HEADER_SIZE = 9;
    protected static final boolean DONT_RECYCLE = Boolean.getBoolean(Http2Frame.class.getName() + ".dont-recycle");
    private int flags;
    private int streamId = 0;
    protected int length = -1;
    protected Buffer frameBuffer;

    protected Http2Frame() {
    }

    public Buffer toBuffer() {
        return this.toBuffer(MemoryManager.DEFAULT_MEMORY_MANAGER);
    }

    public abstract Buffer toBuffer(MemoryManager var1);

    public boolean isFlagSet(int flag) {
        return (this.flags & flag) == flag;
    }

    public void setFlag(int flag) {
        this.flags |= flag;
    }

    public void clearFlag(int flag) {
        this.flags &= ~flag;
    }

    public int getFlags() {
        return this.flags;
    }

    protected void setFlags(int flags) {
        this.flags = flags;
    }

    public int getLength() {
        if (this.length == -1) {
            this.length = this.calcLength();
        }
        return this.length;
    }

    protected abstract int calcLength();

    protected abstract Map<Integer, String> getFlagNamesMap();

    protected void onPayloadUpdated() {
        this.length = -1;
    }

    public abstract int getType();

    public int getStreamId() {
        return this.streamId;
    }

    protected void setStreamId(int streamId) {
        this.streamId = streamId;
    }

    public String toString() {
        return "{" + this.headerToString() + "}";
    }

    public String headerToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("streamId=").append(this.streamId);
        sb.append(", type=").append(this.getType());
        sb.append(", flags=[").append(Http2Frame.flagsToString(this.flags, this.getFlagNamesMap())).append(']');
        sb.append(", length=").append(this.getLength());
        return sb.toString();
    }

    protected void setFrameBuffer(Buffer frameBuffer) {
        this.frameBuffer = frameBuffer;
    }

    protected void serializeFrameHeader(Buffer buffer) {
        assert (buffer.remaining() >= 9);
        buffer.putInt((this.getLength() & 0xFFFFFF) << 8 | this.getType());
        buffer.put((byte)this.getFlags());
        buffer.putInt(this.getStreamId());
    }

    public void recycle() {
        if (DONT_RECYCLE) {
            return;
        }
        this.flags = 0;
        this.length = -1;
        this.streamId = 0;
        if (this.frameBuffer != null) {
            this.frameBuffer.tryDispose();
            this.frameBuffer = null;
        }
    }

    private static String flagsToString(int flags, Map<Integer, String> flagsNameMap) {
        if (flags == 0) {
            return "none";
        }
        StringBuilder sb = new StringBuilder();
        while (flags != 0) {
            int flagsNext = flags & flags - 1;
            int lowestOneBit = flags - flagsNext;
            String name = flagsNameMap.get(lowestOneBit);
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            sb.append(name != null ? name : sb.append('#').append(Integer.numberOfLeadingZeros(flags)));
            flags = flagsNext;
        }
        return sb.toString();
    }

    protected static abstract class Http2FrameBuilder<T extends Http2FrameBuilder> {
        protected int flags;
        protected int streamId;

        protected Http2FrameBuilder() {
        }

        public abstract Http2Frame build();

        public T setFlag(int flag) {
            this.flags |= flag;
            return this.getThis();
        }

        public T clearFlag(int flag) {
            this.flags &= ~flag;
            return this.getThis();
        }

        public T streamId(int streamId) {
            this.streamId = streamId;
            return this.getThis();
        }

        protected void setHeaderValuesTo(Http2Frame frame) {
            frame.flags = this.flags;
            frame.streamId = this.streamId;
        }

        protected abstract T getThis();
    }
}

