/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.frames;

import java.util.Collections;
import java.util.Map;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http2.frames.ErrorCode;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;

public class GoAwayFrame
extends Http2Frame {
    private static final ThreadCache.CachedTypeIndex<GoAwayFrame> CACHE_IDX = ThreadCache.obtainIndex(GoAwayFrame.class, (int)8);
    public static final int TYPE = 7;
    private int lastStreamId;
    private ErrorCode errorCode;
    private Buffer additionalDebugData;

    private GoAwayFrame() {
    }

    static GoAwayFrame create() {
        GoAwayFrame frame = (GoAwayFrame)ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new GoAwayFrame();
        }
        return frame;
    }

    public static Http2Frame fromBuffer(int streamId, Buffer frameBuffer) {
        GoAwayFrame frame = GoAwayFrame.create();
        frame.setStreamId(streamId);
        frame.lastStreamId = frameBuffer.getInt() & Integer.MAX_VALUE;
        frame.errorCode = ErrorCode.lookup(frameBuffer.getInt());
        frame.additionalDebugData = frameBuffer.hasRemaining() ? frameBuffer : null;
        frame.setFrameBuffer(frameBuffer);
        return frame;
    }

    public static GoAwayFrameBuilder builder() {
        return new GoAwayFrameBuilder();
    }

    public int getLastStreamId() {
        return this.lastStreamId;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public Buffer getAdditionalDebugData() {
        return this.additionalDebugData;
    }

    @Override
    public String toString() {
        boolean hasAddData = this.additionalDebugData != null && this.additionalDebugData.hasRemaining();
        StringBuilder sb = new StringBuilder();
        sb.append("GoAwayFrame {").append(this.headerToString()).append("{lastStreamId=").append(this.lastStreamId).append(", errorCode=").append((Object)this.errorCode);
        if (hasAddData) {
            sb.append(", additionalDebugData={").append(this.additionalDebugData.toStringContent()).append('}');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public Buffer toBuffer(MemoryManager memoryManager) {
        Buffer buffer = memoryManager.allocate(17);
        this.serializeFrameHeader(buffer);
        buffer.putInt(this.lastStreamId & Integer.MAX_VALUE);
        buffer.putInt(this.errorCode.getCode());
        buffer.trim();
        if (this.additionalDebugData == null || !this.additionalDebugData.hasRemaining()) {
            return buffer;
        }
        CompositeBuffer cb = CompositeBuffer.newBuffer((MemoryManager)memoryManager, (Buffer[])new Buffer[]{buffer, this.additionalDebugData});
        cb.allowBufferDispose(true);
        cb.allowInternalBuffersDispose(true);
        return cb;
    }

    @Override
    protected int calcLength() {
        return 8 + (this.additionalDebugData != null ? this.additionalDebugData.remaining() : 0);
    }

    @Override
    protected Map<Integer, String> getFlagNamesMap() {
        return Collections.emptyMap();
    }

    @Override
    public void recycle() {
        if (DONT_RECYCLE) {
            return;
        }
        this.errorCode = null;
        this.lastStreamId = 0;
        this.additionalDebugData = null;
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    public static class GoAwayFrameBuilder
    extends Http2Frame.Http2FrameBuilder<GoAwayFrameBuilder> {
        private int lastStreamId;
        private ErrorCode errorCode;
        private Buffer additionalDebugData;

        protected GoAwayFrameBuilder() {
        }

        public GoAwayFrameBuilder errorCode(ErrorCode errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public GoAwayFrameBuilder lastStreamId(int lastStreamId) {
            this.lastStreamId = lastStreamId;
            return this;
        }

        public GoAwayFrameBuilder additionalDebugData(Buffer additionalDebugData) {
            this.additionalDebugData = additionalDebugData;
            return this;
        }

        @Override
        public GoAwayFrame build() {
            GoAwayFrame frame = GoAwayFrame.create();
            this.setHeaderValuesTo(frame);
            frame.lastStreamId = this.lastStreamId;
            frame.errorCode = this.errorCode;
            frame.additionalDebugData = this.additionalDebugData;
            return frame;
        }

        @Override
        protected GoAwayFrameBuilder getThis() {
            return this;
        }
    }
}

