/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http2.Http2Header;
import org.glassfish.grizzly.http2.Http2Stream;

class Http2Response
extends HttpResponsePacket
implements Http2Header {
    private static final ThreadCache.CachedTypeIndex<Http2ResponseRecyclable> CACHE_IDX = ThreadCache.obtainIndex(Http2ResponseRecyclable.class, (int)2);
    private boolean contentTypeParsed;

    Http2Response() {
    }

    public static Http2Response create() {
        Http2Response http2Response = (Http2Response)ThreadCache.takeFromCache(CACHE_IDX);
        if (http2Response == null) {
            http2Response = new Http2Response();
        }
        return http2Response;
    }

    public ProcessingState getProcessingState() {
        return this.getRequest().getProcessingState();
    }

    @Override
    public Http2Stream getHttp2Stream() {
        return Http2Stream.getStreamFor((HttpHeader)this);
    }

    public String getCharacterEncoding() {
        if (!this.contentTypeParsed) {
            this.parseContentTypeHeader();
        }
        return super.getCharacterEncoding();
    }

    public void setCharacterEncoding(String charset) {
        if (!this.contentTypeParsed) {
            this.parseContentTypeHeader();
        }
        super.setCharacterEncoding(charset);
    }

    public String getContentType() {
        if (!this.contentTypeParsed) {
            this.parseContentTypeHeader();
        }
        return super.getContentType();
    }

    private void parseContentTypeHeader() {
        DataChunk dc;
        this.contentTypeParsed = true;
        if (!this.contentType.isSet() && (dc = this.headers.getValue(Header.ContentType)) != null && !dc.isNull()) {
            this.setContentType(dc.toString());
        }
    }

    @Override
    public void setExpectContent(boolean isExpectContent) {
        super.setExpectContent(isExpectContent);
    }

    protected void reset() {
        this.contentTypeParsed = false;
        super.reset();
    }

    private static class Http2ResponseRecyclable
    extends Http2Response {
        private Http2ResponseRecyclable() {
        }

        public void recycle() {
            this.reset();
            ThreadCache.putToCache(CACHE_IDX, (Object)this);
        }
    }
}

