/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.OutputSink;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpEvents;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpTrailer;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HeaderValue;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http2.AlpnClientNegotiatorImpl;
import org.glassfish.grizzly.http2.AlpnSupport;
import org.glassfish.grizzly.http2.DecoderUtils;
import org.glassfish.grizzly.http2.Http2BaseFilter;
import org.glassfish.grizzly.http2.Http2Configuration;
import org.glassfish.grizzly.http2.Http2Request;
import org.glassfish.grizzly.http2.Http2Response;
import org.glassfish.grizzly.http2.Http2Session;
import org.glassfish.grizzly.http2.Http2SessionException;
import org.glassfish.grizzly.http2.Http2State;
import org.glassfish.grizzly.http2.Http2Stream;
import org.glassfish.grizzly.http2.Http2StreamException;
import org.glassfish.grizzly.http2.NetLogger;
import org.glassfish.grizzly.http2.Termination;
import org.glassfish.grizzly.http2.frames.ErrorCode;
import org.glassfish.grizzly.http2.frames.HeaderBlockHead;
import org.glassfish.grizzly.http2.frames.HeadersFrame;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.http2.frames.PushPromiseFrame;
import org.glassfish.grizzly.http2.frames.SettingsFrame;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.npn.AlpnClientNegotiator;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLFilter;

public class Http2ClientFilter
extends Http2BaseFilter {
    private static final Logger LOGGER = Logger.getLogger(Http2ClientFilter.class.getName());
    private final AlpnClientNegotiatorImpl defaultClientAlpnNegotiator = new AlpnClientNegotiatorImpl(this);
    private boolean isNeverForceUpgrade;
    private boolean sendPushRequestUpstream;
    private final HeaderValue defaultHttp2Upgrade = HeaderValue.newHeaderValue((String)"h2c");
    private final HeaderValue connectionUpgradeHeaderValue = HeaderValue.newHeaderValue((String)"Upgrade, HTTP2-Settings");

    public Http2ClientFilter(Http2Configuration configuration) {
        super(configuration);
    }

    public boolean isNeverForceUpgrade() {
        return this.isNeverForceUpgrade;
    }

    public void setNeverForceUpgrade(boolean neverForceUpgrade) {
        this.isNeverForceUpgrade = neverForceUpgrade;
    }

    public boolean isSendPushRequestUpstream() {
        return this.sendPushRequestUpstream;
    }

    public void setSendPushRequestUpstream(boolean sendPushRequestUpstream) {
        this.sendPushRequestUpstream = sendPushRequestUpstream;
    }

    public NextAction handleConnect(final FilterChainContext ctx) throws IOException {
        LOGGER.finest(() -> String.format("handleConnect(ctx=%s)", ctx));
        Connection connection = ctx.getConnection();
        FilterChain filterChain = (FilterChain)connection.getProcessor();
        int idx = filterChain.indexOfType(SSLFilter.class);
        if (idx != -1) {
            SSLFilter sslFilter = (SSLFilter)filterChain.get(idx);
            LOGGER.finest(() -> String.format("Using AlpnSupport for filter: %s", sslFilter));
            AlpnSupport.getInstance().configure((SSLBaseFilter)sslFilter);
            AlpnSupport.getInstance().setClientSideNegotiator(connection, this.getClientAlpnNegotiator());
            NextAction suspendAction = ctx.getSuspendAction();
            ctx.suspend();
            sslFilter.handshake(connection, (CompletionHandler)new EmptyCompletionHandler<SSLEngine>(){

                public void completed(SSLEngine result) {
                    ctx.resumeNext();
                }

                public void failed(Throwable throwable) {
                    ctx.fail(throwable);
                }
            });
            connection.enableIOEvent(IOEvent.READ);
            return suspendAction;
        }
        if (this.getConfiguration().isPriorKnowledge()) {
            LOGGER.finest(() -> String.format("Using HTTP 1.1 upgrade mechanism for connection: %s", connection));
            Http2Session http2Session = this.createClientHttp2Session(connection);
            final Http2State state = http2Session.getHttp2State();
            state.setDirectUpgradePhase();
            http2Session.sendPreface();
            NextAction suspendAction = ctx.getSuspendAction();
            ctx.suspend();
            state.addReadyListener(new Http2State.ReadyListener(){

                @Override
                public void ready(Http2Session http2Session) {
                    state.onClientHttpUpgradeRequestFinished();
                    http2Session.setupFilterChains(ctx, true);
                    ctx.resumeNext();
                }
            });
            connection.enableIOEvent(IOEvent.READ);
            return suspendAction;
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        LOGGER.finest(() -> String.format("handleRead(ctx=%s)", ctx));
        if (this.checkIfHttp2StreamChain(ctx)) {
            LOGGER.finest("Already registered HTTP2 stream chain, invoking action.");
            return ctx.getInvokeAction();
        }
        Connection connection = ctx.getConnection();
        Http2State http2State = Http2State.get(connection);
        if (http2State == null || http2State.isNeverHttp2()) {
            LOGGER.finest("Not a HTTP2 connection, invoking action.");
            return ctx.getInvokeAction();
        }
        HttpContent httpContent = (HttpContent)ctx.getMessage();
        HttpHeader httpHeader = httpContent.getHttpHeader();
        if (http2State.isHttpUpgradePhase()) {
            assert (!httpHeader.isRequest());
            HttpResponsePacket httpResponse = (HttpResponsePacket)httpHeader;
            HttpRequestPacket httpRequest = httpResponse.getRequest();
            if (!this.tryHttpUpgrade(ctx, http2State, httpRequest, httpResponse)) {
                LOGGER.finest("Upgrade to HTTP2 didn't work out. Invoking action.");
                http2State.setNeverHttp2();
                return ctx.getInvokeAction();
            }
        }
        Http2Session http2Session = this.obtainHttp2Session(http2State, ctx, true);
        Buffer framePayload = httpContent.getContent();
        httpContent.recycle();
        List<Http2Frame> framesList = this.frameCodec.parse(http2Session, http2State.getFrameParsingState(), framePayload);
        if (!this.processFrames(ctx, http2Session, framesList)) {
            return ctx.getSuspendAction();
        }
        return ctx.getStopAction();
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        LOGGER.finest(() -> String.format("handleWrite(ctx=%s)", ctx));
        Connection connection = ctx.getConnection();
        Http2State http2State = Http2State.get(connection);
        if (http2State != null && http2State.isNeverHttp2()) {
            return ctx.getInvokeAction();
        }
        if (http2State == null) {
            http2State = Http2State.create(connection);
            Object msg = ctx.getMessage();
            if (!this.tryInsertHttpUpgradeHeaders(connection, msg)) {
                http2State.setNeverHttp2();
            }
            assert (HttpPacket.isHttp((Object)ctx.getMessage()));
            this.checkIfLastHttp11Chunk(ctx, http2State, msg);
            return ctx.getInvokeAction();
        }
        if (http2State.isHttpUpgradePhase()) {
            Object msg = ctx.getMessage();
            if (HttpPacket.isHttp((Object)msg)) {
                if (!((HttpPacket)msg).getHttpHeader().isCommitted()) {
                    throw new IllegalStateException("Can't pipeline HTTP requests because it's still not clear if HTTP/1.x or HTTP/2 will be used");
                }
                this.checkIfLastHttp11Chunk(ctx, http2State, msg);
            }
            return ctx.getInvokeAction();
        }
        return super.handleWrite(ctx);
    }

    @Override
    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        LOGGER.finest(() -> String.format("handleEvent(ctx=%s, event=%s)", ctx, event));
        if (!Http2State.isHttp2(ctx.getConnection())) {
            return ctx.getInvokeAction();
        }
        Object type = event.type();
        if (type == HttpEvents.OutgoingHttpUpgradeEvent.TYPE) {
            assert (event instanceof HttpEvents.OutgoingHttpUpgradeEvent);
            HttpEvents.OutgoingHttpUpgradeEvent outUpgradeEvent = (HttpEvents.OutgoingHttpUpgradeEvent)event;
            outUpgradeEvent.getHttpHeader().setIgnoreContentModifiers(false);
            return ctx.getStopAction();
        }
        return ctx.getInvokeAction();
    }

    @Override
    protected void processOutgoingHttpHeader(FilterChainContext ctx, Http2Session http2Session, HttpHeader httpHeader, HttpPacket entireHttpPacket) throws IOException {
        Http2Stream stream;
        if (!http2Session.isHttp2OutputEnabled()) {
            return;
        }
        HttpRequestPacket request = (HttpRequestPacket)httpHeader;
        if (!request.isCommitted()) {
            this.prepareOutgoingRequest(request);
        }
        if ((stream = Http2Stream.getStreamFor((HttpHeader)request)) == null) {
            this.processOutgoingRequestForNewStream(ctx, http2Session, request, entireHttpPacket);
        } else {
            FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
            stream.getOutputSink().writeDownStream(entireHttpPacket, ctx, (CompletionHandler<WriteResult>)transportContext.getCompletionHandler(), (MessageCloner<Buffer>)transportContext.getMessageCloner());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOutgoingRequestForNewStream(FilterChainContext ctx, Http2Session http2Session, HttpRequestPacket request, HttpPacket entireHttpPacket) throws IOException {
        ReentrantLock newStreamLock = http2Session.getNewClientStreamLock();
        newStreamLock.lock();
        try {
            Http2Stream stream = http2Session.openStream(request, http2Session.getNextLocalStreamId(), 0, false, 0);
            if (stream == null) {
                throw new IOException("Http2Session is closed");
            }
            request.setAttribute(Http2Stream.HTTP2_STREAM_ATTRIBUTE, (Object)stream);
            FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
            stream.getOutputSink().writeDownStream(entireHttpPacket, ctx, (CompletionHandler<WriteResult>)transportContext.getCompletionHandler(), (MessageCloner<Buffer>)transportContext.getMessageCloner());
        }
        finally {
            newStreamLock.unlock();
        }
    }

    protected Http2Session createClientHttp2Session(Connection connection) {
        return this.createHttp2Session(connection, false);
    }

    protected AlpnClientNegotiator getClientAlpnNegotiator() {
        return this.defaultClientAlpnNegotiator;
    }

    private boolean tryHttpUpgrade(FilterChainContext ctx, Http2State http2State, HttpRequestPacket httpRequest, HttpResponsePacket httpResponse) throws Http2StreamException, IOException {
        if (httpRequest == null) {
            return false;
        }
        if (!this.checkRequestHeadersOnUpgrade(httpRequest)) {
            return false;
        }
        if (!this.checkResponseHeadersOnUpgrade(httpResponse)) {
            return false;
        }
        Connection connection = ctx.getConnection();
        http2State.setDirectUpgradePhase();
        Http2Session http2Session = this.createClientHttp2Session(connection);
        if (http2State.tryLockClientPreface()) {
            http2Session.sendPreface();
        }
        http2Session.setupFilterChains(ctx, true);
        httpResponse.setStatus(HttpStatus.OK_200);
        httpResponse.getHeaders().clear();
        httpRequest.setProtocol(Protocol.HTTP_2_0);
        httpResponse.setProtocol(Protocol.HTTP_2_0);
        httpResponse.getUpgradeDC().recycle();
        httpResponse.getProcessingState().setKeepAlive(true);
        if (http2Session.isGoingAway()) {
            return false;
        }
        Http2Stream stream = http2Session.openUpgradeStream(httpRequest, 0);
        HttpContext oldHttpContext = httpResponse.getProcessingState().getHttpContext();
        HttpContext httpContext = HttpContext.newInstance((AttributeStorage)stream, (OutputSink)stream, (Closeable)stream, (HttpRequestPacket)httpRequest);
        httpRequest.getProcessingState().setHttpContext(httpContext);
        httpContext.attach(ctx);
        HttpRequestPacket dummyRequestPacket = ((HttpRequestPacket.Builder)HttpRequestPacket.builder().method(Method.PRI).uri("/dummy_pri").protocol(Protocol.HTTP_2_0)).build();
        HttpResponsePacket dummyResponsePacket = ((HttpResponsePacket.Builder)HttpResponsePacket.builder((HttpRequestPacket)dummyRequestPacket).status(200).reasonPhrase("OK").protocol(Protocol.HTTP_2_0)).build();
        dummyResponsePacket.getProcessingState().setHttpContext(oldHttpContext);
        dummyResponsePacket.setIgnoreContentModifiers(true);
        ctx.notifyDownstream((FilterChainEvent)HttpEvents.createChangePacketInProgressEvent((HttpHeader)dummyResponsePacket));
        return true;
    }

    private boolean tryInsertHttpUpgradeHeaders(Connection connection, Object msg) {
        if (this.isNeverForceUpgrade) {
            return false;
        }
        if (!HttpPacket.isHttp((Object)msg)) {
            return false;
        }
        HttpHeader httpHeader = ((HttpPacket)msg).getHttpHeader();
        if (!httpHeader.isRequest() || httpHeader.isUpgrade() || httpHeader.getProtocol() != Protocol.HTTP_1_1 || httpHeader.containsHeader(Header.Connection)) {
            return false;
        }
        httpHeader.addHeader(Header.Upgrade, this.defaultHttp2Upgrade);
        httpHeader.addHeader(Header.Connection, this.connectionUpgradeHeaderValue);
        httpHeader.addHeader(Header.HTTP2Settings, this.prepareSettings(Http2Session.get(connection)).build().toBase64Uri());
        return true;
    }

    @Override
    protected void processCompleteHeader(Http2Session http2Session, FilterChainContext context, HeaderBlockHead firstHeaderFrame) throws IOException {
        if (!Http2ClientFilter.ignoreFrameForStreamId(http2Session, firstHeaderFrame.getStreamId())) {
            switch (firstHeaderFrame.getType()) {
                case 5: {
                    this.processInPushPromise(http2Session, context, (PushPromiseFrame)firstHeaderFrame);
                    break;
                }
                default: {
                    this.processInResponse(http2Session, context, (HeadersFrame)firstHeaderFrame);
                }
            }
        }
    }

    private void processInResponse(Http2Session http2Session, FilterChainContext context, HeadersFrame headersFrame) throws Http2SessionException, IOException {
        HttpContent content;
        LinkedHashMap<String, String> capture;
        Http2Stream stream = http2Session.getStream(headersFrame.getStreamId());
        if (stream == null) {
            return;
        }
        HttpRequestPacket request = stream.getRequest();
        HttpResponsePacket response = request.getResponse();
        if (response == null) {
            response = Http2Response.create();
        }
        boolean isEOS = headersFrame.isEndStream();
        this.bind(request, response);
        stream.onRcvHeaders(isEOS);
        LinkedHashMap<String, String> linkedHashMap = capture = NetLogger.isActive() ? new LinkedHashMap<String, String>() : null;
        if (stream.getInboundHeaderFramesCounter() == 1) {
            if (isEOS) {
                response.setExpectContent(false);
                stream.inputBuffer.terminate(Termination.IN_FIN_TERMINATION);
            }
            DecoderUtils.decodeResponseHeaders(http2Session, response, capture);
            this.onHttpHeadersParsed((HttpHeader)response, context);
            response.getHeaders().mark();
            content = response.httpContentBuilder().content(Buffers.EMPTY_BUFFER).last(isEOS).build();
        } else {
            DecoderUtils.decodeTrailerHeaders(http2Session, (HttpHeader)response, capture);
            HttpTrailer trailer = ((HttpTrailer.Builder)((HttpTrailer.Builder)response.httpTrailerBuilder().content(Buffers.EMPTY_BUFFER)).last(isEOS)).build();
            MimeHeaders mimeHeaders = response.getHeaders();
            if (mimeHeaders.trailerSize() > 0) {
                for (String name : mimeHeaders.trailerNames()) {
                    trailer.addHeader(name, mimeHeaders.getHeader(name));
                }
            }
            content = trailer;
            stream.flushInputData();
        }
        NetLogger.log(NetLogger.Context.RX, http2Session, headersFrame, capture);
        if (isEOS) {
            this.onHttpPacketParsed((HttpHeader)response, context);
        }
        this.sendUpstream(http2Session, stream, content);
    }

    private void processInPushPromise(Http2Session http2Session, FilterChainContext context, PushPromiseFrame pushPromiseFrame) throws Http2StreamException, IOException {
        if (http2Session.isGoingAway()) {
            return;
        }
        Http2Request request = Http2Request.create();
        request.setConnection(context.getConnection());
        int refStreamId = pushPromiseFrame.getStreamId();
        Http2Stream refStream = http2Session.getStream(refStreamId);
        if (refStream == null) {
            throw new Http2StreamException(refStreamId, ErrorCode.REFUSED_STREAM, "PushPromise is sent over unknown stream: " + refStreamId);
        }
        Http2Stream stream = http2Session.acceptStream(request, pushPromiseFrame.getPromisedStreamId(), refStreamId, false, 0);
        LinkedHashMap<String, String> capture = NetLogger.isActive() ? new LinkedHashMap<String, String>() : null;
        DecoderUtils.decodeRequestHeaders(http2Session, request, capture);
        NetLogger.log(NetLogger.Context.RX, http2Session, pushPromiseFrame, capture);
        this.onHttpHeadersParsed((HttpHeader)request, context);
        this.prepareIncomingRequest(stream, request);
        stream.outputSink.terminate(Termination.OUT_FIN_TERMINATION);
        stream.onReceivePushPromise();
        if (this.sendPushRequestUpstream) {
            this.sendUpstream(http2Session, stream, request.httpContentBuilder().content(Buffers.EMPTY_BUFFER).last(false).build());
        }
    }

    protected SettingsFrame.SettingsFrameBuilder prepareSettings(Http2Session http2Session) {
        int initWindSize;
        SettingsFrame.SettingsFrameBuilder builder = SettingsFrame.builder();
        int maxConcStreams = this.getConfiguration().getMaxConcurrentStreams();
        if (maxConcStreams != -1 && maxConcStreams != http2Session.getDefaultMaxConcurrentStreams()) {
            builder.setting(3, maxConcStreams);
        }
        if ((initWindSize = this.getConfiguration().getInitialWindowSize()) != -1 && http2Session != null && initWindSize != http2Session.getDefaultStreamWindowSize()) {
            builder.setting(4, initWindSize);
        }
        builder.setting(2, this.getConfiguration().isPushEnabled() ? 1 : 0);
        return builder;
    }

    private void checkIfLastHttp11Chunk(FilterChainContext ctx, final Http2State http2State, Object msg) {
        if (HttpContent.isContent((HttpPacket)((HttpPacket)msg)) && ((HttpContent)msg).isLast()) {
            http2State.onClientHttpUpgradeRequestFinished();
            ctx.addCompletionListener(new FilterChainContext.CompletionListener(){

                public void onComplete(FilterChainContext context) {
                    if (http2State.tryLockClientPreface()) {
                        Http2Session http2Session = http2State.getHttp2Session();
                        assert (http2Session != null);
                        http2Session.sendPreface();
                    }
                }
            });
        }
    }
}

