/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.Arrays;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.WriteResult;

class AggrCompletionHandler
implements CompletionHandler<WriteResult> {
    private Record[] completionHandlerRecords = new Record[2];
    private int recordsCount;

    AggrCompletionHandler() {
    }

    public void register(CompletionHandler<WriteResult> completionHandler, int bytesWrittenToReport) {
        this.ensureCapacity();
        Record record = this.completionHandlerRecords[this.recordsCount];
        if (record == null) {
            this.completionHandlerRecords[this.recordsCount] = record = new Record(completionHandler, bytesWrittenToReport);
        } else {
            record.set(completionHandler, bytesWrittenToReport);
        }
        ++this.recordsCount;
    }

    public void cancelled() {
        for (int i = 0; i < this.recordsCount; ++i) {
            try {
                Record record = this.completionHandlerRecords[i];
                CompletionHandler<WriteResult> completionHandler = record.completionHandler;
                record.reset();
                completionHandler.cancelled();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.recordsCount = 0;
    }

    public void failed(Throwable throwable) {
        for (int i = 0; i < this.recordsCount; ++i) {
            try {
                Record record = this.completionHandlerRecords[i];
                CompletionHandler<WriteResult> completionHandler = record.completionHandler;
                record.reset();
                completionHandler.failed(throwable);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.recordsCount = 0;
    }

    public void completed(WriteResult result) {
        long originalWrittenSize = result.getWrittenSize();
        for (int i = 0; i < this.recordsCount; ++i) {
            try {
                Record record = this.completionHandlerRecords[i];
                CompletionHandler<WriteResult> completionHandler = record.completionHandler;
                int bytesWrittenToReport = record.bytesWrittenToReport;
                record.reset();
                result.setWrittenSize((long)bytesWrittenToReport);
                completionHandler.completed((Object)result);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        result.setWrittenSize(originalWrittenSize);
        this.recordsCount = 0;
    }

    public void updated(WriteResult result) {
    }

    private void ensureCapacity() {
        if (this.completionHandlerRecords.length == this.recordsCount) {
            this.completionHandlerRecords = Arrays.copyOf(this.completionHandlerRecords, this.recordsCount + (this.recordsCount >> 1) + 1);
        }
    }

    private static class Record {
        private CompletionHandler<WriteResult> completionHandler;
        private int bytesWrittenToReport;

        Record(CompletionHandler<WriteResult> completionHandler, int bytesWrittenToReport) {
            this.completionHandler = completionHandler;
            this.bytesWrittenToReport = bytesWrittenToReport;
        }

        void set(CompletionHandler<WriteResult> completionHandler, int bytesWrittenToReport) {
            this.completionHandler = completionHandler;
            this.bytesWrittenToReport = bytesWrittenToReport;
        }

        void reset() {
            this.completionHandler = null;
        }
    }
}

