/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueueRecord;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpTrailer;
import org.glassfish.grizzly.http2.BundleQueue;
import org.glassfish.grizzly.http2.Http2Session;
import org.glassfish.grizzly.http2.Http2Stream;
import org.glassfish.grizzly.http2.Http2StreamException;
import org.glassfish.grizzly.http2.NetLogger;
import org.glassfish.grizzly.http2.Source;
import org.glassfish.grizzly.http2.StreamOutputSink;
import org.glassfish.grizzly.http2.Termination;
import org.glassfish.grizzly.http2.frames.ErrorCode;
import org.glassfish.grizzly.http2.frames.HeadersFrame;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.http2.utils.ChunkedCompletionHandler;
import org.glassfish.grizzly.memory.Buffers;

class DefaultOutputSink
implements StreamOutputSink {
    private static final Logger LOGGER = Grizzly.logger(DefaultOutputSink.class);
    private static final int MAX_OUTPUT_QUEUE_SIZE = 65536;
    private static final int ZERO_QUEUE_RECORD_SIZE = 1;
    private static final OutputQueueRecord TERMINATING_QUEUE_RECORD = new OutputQueueRecord(null, null, true, true);
    final TaskQueue<OutputQueueRecord> outputQueue = TaskQueue.createTaskQueue((TaskQueue.MutableMaxQueueSize)new TaskQueue.MutableMaxQueueSize(){

        public int getMaxQueueSize() {
            return 65536;
        }
    });
    private final AtomicInteger availStreamWindowSize;
    private volatile boolean isLastFrameQueued;
    private Termination terminationFlag;
    private final Http2Session http2Session;
    private final Http2Stream stream;
    private final AtomicInteger unflushedWritesCounter = new AtomicInteger();
    private final Object flushHandlersSync = new Object();
    private BundleQueue<CompletionHandler<Http2Stream>> flushHandlersQueue;

    DefaultOutputSink(Http2Stream stream) {
        this.stream = stream;
        this.http2Session = stream.getHttp2Session();
        this.availStreamWindowSize = new AtomicInteger(stream.getPeerWindowSize());
    }

    @Override
    public boolean canWrite() {
        return this.outputQueue.size() < 65536;
    }

    @Override
    public void notifyWritePossible(WriteHandler writeHandler) {
        this.outputQueue.notifyWritePossible(writeHandler, 65536);
    }

    private void assertReady() throws IOException {
        if (this.isTerminated()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Terminated!!! id={0} description={1}", new Object[]{this.stream.getId(), this.terminationFlag.getDescription()});
            }
            throw new IOException(this.terminationFlag.getDescription());
        }
        if (this.isLastFrameQueued) {
            throw new IOException("Write beyond end of stream");
        }
    }

    @Override
    public void onPeerWindowUpdate(int delta) throws Http2StreamException {
        int currentWindow = this.availStreamWindowSize.get();
        if (delta > 0 && currentWindow > 0 && currentWindow + delta < 0) {
            throw new Http2StreamException(this.stream.getId(), ErrorCode.FLOW_CONTROL_ERROR, "Session flow-control window overflow.");
        }
        this.availStreamWindowSize.addAndGet(delta);
        while (this.isWantToWrite() && !this.outputQueue.isEmpty() || this.outputQueue.peek() != null && ((OutputQueueRecord)this.outputQueue.peek()).trailer != null) {
            OutputQueueRecord outputQueueRecord = (OutputQueueRecord)this.outputQueue.poll();
            if (outputQueueRecord == null) {
                return;
            }
            if (outputQueueRecord == TERMINATING_QUEUE_RECORD) {
                this.releaseWriteQueueSpace(0, true, true);
                this.writeEmptyFin();
                return;
            }
            FlushCompletionHandler completionHandler = outputQueueRecord.chunkedCompletionHandler;
            boolean isLast = outputQueueRecord.isLast;
            boolean isZeroSizeData = outputQueueRecord.isZeroSizeData;
            Source resource = outputQueueRecord.resource;
            HttpTrailer currentTrailer = outputQueueRecord.trailer;
            if (currentTrailer != null) {
                outputQueueRecord = null;
                this.sendTrailers(completionHandler, currentTrailer);
                return;
            }
            int bytesToSend = this.checkOutputWindow(resource.remaining());
            Buffer dataChunkToSend = resource.read(bytesToSend);
            boolean hasRemaining = resource.hasRemaining();
            if (hasRemaining) {
                outputQueueRecord.reset(resource, completionHandler, isLast);
                outputQueueRecord.incChunksCounter();
                isLast = false;
            } else {
                outputQueueRecord.release();
                outputQueueRecord = null;
            }
            if (dataChunkToSend != null && (dataChunkToSend.hasRemaining() || isLast)) {
                int dataChunkToSendSize = dataChunkToSend.remaining();
                this.flushToConnectionOutputSink(dataChunkToSend, completionHandler, isLast);
                this.availStreamWindowSize.addAndGet(-dataChunkToSendSize);
                this.releaseWriteQueueSpace(dataChunkToSendSize, isZeroSizeData, outputQueueRecord == null);
                this.outputQueue.doNotify();
            } else if (isZeroSizeData && outputQueueRecord == null) {
                this.releaseWriteQueueSpace(0, true, true);
                this.outputQueue.doNotify();
            }
            if (outputQueueRecord == null) continue;
            this.outputQueue.setCurrentElement((AsyncQueueRecord)outputQueueRecord);
            break;
        }
    }

    @Override
    public synchronized void writeDownStream(HttpPacket httpPacket, FilterChainContext ctx, CompletionHandler<WriteResult> completionHandler, MessageCloner<Buffer> messageCloner) throws IOException {
        assert (ctx != null);
        this.assertReady();
        OutputQueueRecord next = this.writeDownStream0(httpPacket, ctx, completionHandler, messageCloner);
        if (next != null) {
            this.addOutputQueueRecord(next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputQueueRecord writeDownStream0(HttpPacket httpPacket, FilterChainContext ctx, CompletionHandler<WriteResult> completionHandler, MessageCloner<Buffer> messageCloner) throws IOException {
        HttpHeader httpHeader = this.stream.getOutputHttpHeader();
        HttpContent httpContent = HttpContent.isContent((HttpPacket)httpPacket) ? (HttpContent)httpPacket : null;
        List<Http2Frame> headerFrames = null;
        boolean sendTrailers = false;
        boolean lockedByMe = false;
        try {
            OutputQueueRecord outputQueueRecord;
            boolean isLast = httpContent != null && httpContent.isLast();
            boolean isTrailer = HttpTrailer.isTrailer((HttpContent)httpContent);
            if (!httpHeader.isCommitted()) {
                HttpResponsePacket response;
                boolean dontSendPayload = !httpHeader.isExpectContent() || httpContent != null && httpContent.isLast() && !httpContent.getContent().hasRemaining();
                LOGGER.finest(() -> "Header not committed yet; dontSendPayload=" + dontSendPayload);
                this.http2Session.getDeflaterLock().lock();
                lockedByMe = true;
                boolean logging = NetLogger.isActive();
                HashMap<String, String> capture = logging ? new HashMap<String, String>() : null;
                headerFrames = this.http2Session.encodeHttpHeaderAsHeaderFrames(ctx, httpHeader, this.stream.getId(), dontSendPayload, null, capture);
                if (logging) {
                    for (Http2Frame http2Frame : headerFrames) {
                        if (http2Frame.getType() != 5) continue;
                        NetLogger.log(NetLogger.Context.TX, this.http2Session, (HeadersFrame)http2Frame, capture);
                        break;
                    }
                }
                this.stream.onSndHeaders(dontSendPayload);
                if (!httpHeader.isRequest() && (response = (HttpResponsePacket)httpHeader).isAcknowledgement()) {
                    Http2Frame http2Frame;
                    response.acknowledged();
                    response.getHeaders().clear();
                    this.unflushedWritesCounter.incrementAndGet();
                    this.flushToConnectionOutputSink(headerFrames, completionHandler, messageCloner, false);
                    LOGGER.finest("Acknowledgement has been sent.");
                    http2Frame = null;
                    return http2Frame;
                }
                httpHeader.setCommitted(true);
                if (dontSendPayload || httpContent == null) {
                    this.unflushedWritesCounter.incrementAndGet();
                    this.flushToConnectionOutputSink(headerFrames, completionHandler, messageCloner, dontSendPayload);
                    sendTrailers = false;
                    LOGGER.finest(() -> "Nothing to send; dontSendPayload=" + dontSendPayload);
                    response = null;
                    return response;
                }
            }
            if (httpContent == null) {
                sendTrailers = false;
                LOGGER.finest("Nothing to send, httpContent is null.");
                OutputQueueRecord dontSendPayload = null;
                return dontSendPayload;
            }
            this.http2Session.handlerFilter.onHttpContentEncoded(httpContent, ctx);
            Buffer data = httpContent.getContent();
            int dataSize = data.remaining();
            this.unflushedWritesCounter.incrementAndGet();
            FlushCompletionHandler flushCompletionHandler = new FlushCompletionHandler(completionHandler);
            boolean isZeroSizeData = dataSize == 0;
            int spaceToReserve = isZeroSizeData ? 1 : dataSize;
            boolean isDataCloned = false;
            int spaceReserved = this.reserveWriteQueueSpace(spaceToReserve);
            LOGGER.finest(() -> "Bytes reserved: " + spaceReserved + ", was requested: " + spaceToReserve);
            if (spaceReserved > spaceToReserve) {
                assert (headerFrames == null);
                if (messageCloner != null) {
                    data = (Buffer)messageCloner.clone(this.http2Session.getConnection(), (Object)data);
                    isDataCloned = true;
                }
                OutputQueueRecord record = this.createOutputQueueRecord(data, httpContent, flushCompletionHandler, isLast, isZeroSizeData);
                this.outputQueue.offer((AsyncQueueRecord)record);
                if (this.outputQueue.size() != spaceToReserve) {
                    sendTrailers = isLast && isTrailer;
                    OutputQueueRecord outputQueueRecord2 = null;
                    return outputQueueRecord2;
                }
                if (!this.outputQueue.remove((AsyncQueueRecord)record)) {
                    sendTrailers = false;
                    LOGGER.finest("The record has been already processed.");
                    OutputQueueRecord outputQueueRecord3 = null;
                    return outputQueueRecord3;
                }
            }
            int remaining = data.remaining();
            int fitWindowLen = this.checkOutputWindow(remaining);
            LOGGER.finest(() -> "Remaining: " + remaining + ", fitWindowLen: " + fitWindowLen);
            if (fitWindowLen >= remaining) {
                outputQueueRecord = null;
            } else {
                if (!isDataCloned && messageCloner != null) {
                    data = (Buffer)messageCloner.clone(this.http2Session.getConnection(), (Object)data);
                    isDataCloned = true;
                }
                Buffer dataChunkToStore = this.splitOutputBufferIfNeeded(data, fitWindowLen);
                outputQueueRecord = this.createOutputQueueRecord(dataChunkToStore, null, flushCompletionHandler, isLast, isZeroSizeData);
                isLast = false;
            }
            Buffer dataToSend = this.prepareDataToSend(outputQueueRecord == null, isLast, data, isZeroSizeData);
            if (headerFrames != null || dataToSend != null) {
                if (outputQueueRecord != null) {
                    outputQueueRecord.incChunksCounter();
                }
                this.flushToConnectionOutputSink(headerFrames, dataToSend, flushCompletionHandler, isDataCloned ? null : messageCloner, isLast && !isTrailer);
            }
            LOGGER.finest("isLast=" + isLast + "; isTrailer=" + isTrailer);
            sendTrailers = isLast && isTrailer;
            OutputQueueRecord outputQueueRecord4 = isLast ? null : outputQueueRecord;
            return outputQueueRecord4;
        }
        finally {
            LOGGER.finest("sendTrailers=" + sendTrailers);
            if (sendTrailers) {
                this.sendTrailers(completionHandler, (HttpTrailer)httpContent);
            }
            if (lockedByMe) {
                this.http2Session.getDeflaterLock().unlock();
            }
        }
    }

    private OutputQueueRecord createOutputQueueRecord(Buffer data, HttpContent httpContent, FlushCompletionHandler flushCompletionHandler, boolean isLast, boolean isZeroSizeData) {
        Source bufferSource = Source.factory(this.stream).createBufferSource(data);
        if (httpContent instanceof HttpTrailer) {
            return new OutputQueueRecord(bufferSource, flushCompletionHandler, (HttpTrailer)httpContent, false);
        }
        return new OutputQueueRecord(bufferSource, flushCompletionHandler, isLast, isZeroSizeData);
    }

    private Buffer prepareDataToSend(boolean isRecordNull, boolean isLast, Buffer data, boolean isZeroSizeData) {
        if (data == null) {
            return null;
        }
        if (data.hasRemaining() || isLast) {
            int dataChunkToSendSize = data.remaining();
            this.availStreamWindowSize.addAndGet(-dataChunkToSendSize);
            this.releaseWriteQueueSpace(dataChunkToSendSize, isZeroSizeData, isRecordNull);
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(CompletionHandler<Http2Stream> completionHandler) {
        if (this.unflushedWritesCounter.get() > 0) {
            Object object = this.flushHandlersSync;
            synchronized (object) {
                int counterNow = this.unflushedWritesCounter.get();
                if (counterNow > 0) {
                    if (this.flushHandlersQueue == null) {
                        this.flushHandlersQueue = new BundleQueue();
                    }
                    this.flushHandlersQueue.add(counterNow, completionHandler);
                    return;
                }
            }
        }
        completionHandler.completed((Object)this.stream);
    }

    private int checkOutputWindow(long size) {
        return Math.max(0, Math.min(this.availStreamWindowSize.get(), (int)size));
    }

    private Buffer splitOutputBufferIfNeeded(Buffer buffer, int length) {
        if (length == buffer.remaining()) {
            return null;
        }
        return buffer.split(buffer.position() + length);
    }

    private void flushToConnectionOutputSink(List<Http2Frame> headerFrames, CompletionHandler<WriteResult> completionHandler, MessageCloner<Buffer> messageCloner, boolean sendFIN) {
        FlushCompletionHandler flushCompletionHandler = new FlushCompletionHandler(completionHandler);
        this.flushToConnectionOutputSink(headerFrames, null, flushCompletionHandler, messageCloner, sendFIN);
    }

    private void flushToConnectionOutputSink(Buffer data, FlushCompletionHandler flushCompletionHandler, boolean sendFIN) {
        this.flushToConnectionOutputSink(null, data, flushCompletionHandler, null, sendFIN);
    }

    private void flushToConnectionOutputSink(List<Http2Frame> headerFrames, Buffer data, CompletionHandler<WriteResult> completionHandler, MessageCloner<Buffer> messageCloner, boolean sendFIN) {
        this.http2Session.getOutputSink().writeDataDownStream(this.stream, headerFrames, data, completionHandler, messageCloner, sendFIN);
        if (sendFIN) {
            this.terminate(Termination.OUT_FIN_TERMINATION);
        }
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed()) {
            this.isLastFrameQueued = true;
            if (this.outputQueue.isEmpty()) {
                this.writeEmptyFin();
                return;
            }
            this.outputQueue.reserveSpace(1);
            this.outputQueue.offer((AsyncQueueRecord)TERMINATING_QUEUE_RECORD);
            if (this.outputQueue.size() == 1 && this.outputQueue.remove((AsyncQueueRecord)TERMINATING_QUEUE_RECORD)) {
                this.writeEmptyFin();
            }
        }
    }

    @Override
    public synchronized void terminate(Termination terminationFlag) {
        if (!this.isTerminated()) {
            this.terminationFlag = terminationFlag;
            this.outputQueue.onClose();
            this.stream.onOutputClosed();
        }
    }

    @Override
    public boolean isClosed() {
        return this.isLastFrameQueued || this.isTerminated();
    }

    @Override
    public int getUnflushedWritesCount() {
        return this.unflushedWritesCounter.get();
    }

    private boolean isTerminated() {
        return this.terminationFlag != null;
    }

    private void writeEmptyFin() {
        if (!this.isTerminated()) {
            this.unflushedWritesCounter.incrementAndGet();
            this.flushToConnectionOutputSink(Buffers.EMPTY_BUFFER, new FlushCompletionHandler(null), true);
        }
    }

    private boolean isWantToWrite() {
        int windowSizeLimit;
        int availableWindowSizeBytesNow = this.availStreamWindowSize.get();
        return availableWindowSizeBytesNow >= (windowSizeLimit = this.stream.getPeerWindowSize()) / 4;
    }

    private void addOutputQueueRecord(OutputQueueRecord outputQueueRecord) throws Http2StreamException {
        do {
            this.outputQueue.setCurrentElement((AsyncQueueRecord)outputQueueRecord);
            if (!this.isWantToWrite() || !this.outputQueue.compareAndSetCurrentElement((AsyncQueueRecord)outputQueueRecord, null)) break;
            FlushCompletionHandler chunkedCompletionHandler = outputQueueRecord.chunkedCompletionHandler;
            HttpTrailer currentTrailer = outputQueueRecord.trailer;
            if (currentTrailer != null) {
                this.sendTrailers(chunkedCompletionHandler, currentTrailer);
                return;
            }
            boolean isLast = outputQueueRecord.isLast;
            boolean isZeroSizeData = outputQueueRecord.isZeroSizeData;
            Source currentResource = outputQueueRecord.resource;
            int fitWindowLen = this.checkOutputWindow(currentResource.remaining());
            Buffer dataChunkToSend = currentResource.read(fitWindowLen);
            if (currentResource.hasRemaining()) {
                outputQueueRecord.reset(currentResource, chunkedCompletionHandler, isLast);
                outputQueueRecord.incChunksCounter();
                isLast = false;
            } else {
                outputQueueRecord.release();
                outputQueueRecord = null;
            }
            if (dataChunkToSend != null && (dataChunkToSend.hasRemaining() || isLast)) {
                int dataChunkToSendSize = dataChunkToSend.remaining();
                this.flushToConnectionOutputSink(dataChunkToSend, chunkedCompletionHandler, isLast);
                this.availStreamWindowSize.addAndGet(-dataChunkToSendSize);
                this.releaseWriteQueueSpace(dataChunkToSendSize, isZeroSizeData, outputQueueRecord == null);
                continue;
            }
            if (isZeroSizeData && outputQueueRecord == null) {
                this.releaseWriteQueueSpace(0, true, true);
                continue;
            }
            if (dataChunkToSend == null || dataChunkToSend.hasRemaining()) continue;
            if (outputQueueRecord == null) break;
            this.reserveWriteQueueSpace(outputQueueRecord.resource.remaining());
            this.outputQueue.offer((AsyncQueueRecord)outputQueueRecord);
            break;
        } while (outputQueueRecord != null);
    }

    private int reserveWriteQueueSpace(int spaceToReserve) {
        return this.outputQueue.reserveSpace(spaceToReserve);
    }

    private void releaseWriteQueueSpace(int justSentBytes, boolean isAtomic, boolean isEndOfChunk) {
        if (isEndOfChunk) {
            this.outputQueue.releaseSpace(isAtomic ? 1 : justSentBytes);
        } else if (!isAtomic) {
            this.outputQueue.releaseSpace(justSentBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTrailers(CompletionHandler<WriteResult> completionHandler, HttpTrailer httpContent) {
        this.http2Session.getDeflaterLock().lock();
        try {
            boolean logging = NetLogger.isActive();
            HashMap<String, String> capture = logging ? new HashMap<String, String>() : null;
            List<Http2Frame> trailerFrames = this.http2Session.encodeTrailersAsHeaderFrames(this.stream.getId(), new ArrayList<Http2Frame>(4), httpContent.getHeaders(), capture);
            if (logging) {
                for (Http2Frame http2Frame : trailerFrames) {
                    if (http2Frame.getType() != 5) continue;
                    NetLogger.log(NetLogger.Context.TX, this.http2Session, (HeadersFrame)http2Frame, capture);
                    break;
                }
            }
            this.flushToConnectionOutputSink(trailerFrames, completionHandler, null, true);
            this.unflushedWritesCounter.incrementAndGet();
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Error sending trailers.", ex);
        }
        finally {
            this.close();
            LOGGER.finest("Sending trailers finished, unlocking the deflater lock ...");
            this.http2Session.getDeflaterLock().unlock();
        }
    }

    private final class FlushCompletionHandler
    extends ChunkedCompletionHandler {
        public FlushCompletionHandler(CompletionHandler<WriteResult> parentCompletionHandler) {
            super(parentCompletionHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done0() {
            boolean hasNext;
            Object object = DefaultOutputSink.this.flushHandlersSync;
            synchronized (object) {
                DefaultOutputSink.this.unflushedWritesCounter.decrementAndGet();
                if (DefaultOutputSink.this.flushHandlersQueue == null || !DefaultOutputSink.this.flushHandlersQueue.nextBundle()) {
                    return;
                }
            }
            do {
                CompletionHandler handler;
                Object object2 = DefaultOutputSink.this.flushHandlersSync;
                synchronized (object2) {
                    handler = (CompletionHandler)DefaultOutputSink.this.flushHandlersQueue.next();
                    hasNext = DefaultOutputSink.this.flushHandlersQueue.hasNext();
                }
                try {
                    handler.completed((Object)DefaultOutputSink.this.stream);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (hasNext);
        }
    }

    private static class OutputQueueRecord
    extends AsyncQueueRecord<WriteResult> {
        private final HttpTrailer trailer;
        private final boolean isZeroSizeData;
        private Source resource;
        private FlushCompletionHandler chunkedCompletionHandler;
        private boolean isLast;

        public OutputQueueRecord(Source resource, FlushCompletionHandler completionHandler, boolean isLast, boolean isZeroSizeData) {
            super(null, null, null);
            this.resource = resource;
            this.chunkedCompletionHandler = completionHandler;
            this.isLast = isLast;
            this.trailer = null;
            this.isZeroSizeData = isZeroSizeData;
        }

        public OutputQueueRecord(Source resource, FlushCompletionHandler completionHandler, HttpTrailer trailer, boolean isZeroDataSize) {
            super(null, null, null);
            this.resource = resource;
            this.chunkedCompletionHandler = completionHandler;
            this.isLast = true;
            this.trailer = trailer;
            this.isZeroSizeData = isZeroDataSize;
        }

        private void incChunksCounter() {
            if (this.chunkedCompletionHandler != null) {
                this.chunkedCompletionHandler.incChunks();
            }
        }

        private void reset(Source resource, FlushCompletionHandler completionHandler, boolean last) {
            this.resource = resource;
            this.chunkedCompletionHandler = completionHandler;
            this.isLast = last;
        }

        public void release() {
            if (this.resource != null) {
                this.resource.release();
                this.resource = null;
            }
        }

        public void notifyFailure(Throwable e) {
            FlushCompletionHandler chLocal = this.chunkedCompletionHandler;
            this.chunkedCompletionHandler = null;
            try {
                if (chLocal != null) {
                    chLocal.failed(e);
                }
            }
            finally {
                this.release();
            }
        }

        public void recycle() {
        }

        public WriteResult getCurrentResult() {
            return null;
        }
    }
}

