/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpPacketParsing;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpRequestPacketImpl;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpResponsePacketImpl;
import org.glassfish.grizzly.http.KeepAlive;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.FastHttpDateFormat;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HexUtils;
import org.glassfish.grizzly.http.util.HttpCodecUtils;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.DelayedExecutor;

public class HttpServerFilter
extends HttpCodecFilter {
    public static final String HTTP_SERVER_REQUEST_ATTR_NAME = HttpServerFilter.class.getName() + ".HttpRequest";
    public static final FilterChainEvent RESPONSE_COMPLETE_EVENT = new FilterChainEvent(){

        public Object type() {
            return "RESPONSE_COMPLETE_EVENT";
        }
    };
    private static final byte[] CLOSE_BYTES = new byte[]{99, 108, 111, 115, 101};
    private static final byte[] KEEPALIVE_BYTES = new byte[]{107, 101, 101, 112, 45, 97, 108, 105, 118, 101};
    private static final int[] DEC = HexUtils.getDecBytes();
    private final Attribute<HttpRequestPacketImpl> httpRequestInProcessAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(HTTP_SERVER_REQUEST_ATTR_NAME);
    private final Attribute<KeepAliveContext> keepAliveContextAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("HttpServerFilter.KeepAliveContext");
    private final DelayedExecutor.DelayQueue<KeepAliveContext> keepAliveQueue;
    private final KeepAlive keepAlive;
    private final boolean processKeepAlive;
    private String defaultResponseContentType;

    public HttpServerFilter() {
        this(true, 8192, null, null);
    }

    public HttpServerFilter(boolean chunkingEnabled, int maxHeadersSize, KeepAlive keepAlive, DelayedExecutor executor) {
        this(chunkingEnabled, maxHeadersSize, "text/html; charset=iso-8859-1", keepAlive, executor);
    }

    public HttpServerFilter(boolean chunkingEnabled, int maxHeadersSize, String defaultResponseContentType, KeepAlive keepAlive, DelayedExecutor executor) {
        super(chunkingEnabled, maxHeadersSize);
        this.keepAliveQueue = executor != null ? executor.createDelayQueue((DelayedExecutor.Worker)new KeepAliveWorker(keepAlive), (DelayedExecutor.Resolver)new KeepAliveResolver()) : null;
        this.keepAlive = keepAlive;
        boolean bl = this.processKeepAlive = keepAlive != null;
        if (defaultResponseContentType != null && !defaultResponseContentType.isEmpty()) {
            this.defaultResponseContentType = defaultResponseContentType;
        }
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer input = (Buffer)ctx.getMessage();
        Connection connection = ctx.getConnection();
        HttpRequestPacketImpl httpRequest = this.getHttpRequestInProcess(connection);
        if (httpRequest == null) {
            boolean isSecureLocal = HttpServerFilter.isSecure(connection);
            httpRequest = HttpRequestPacketImpl.create();
            httpRequest.initialize(connection, this, input.position(), this.maxHeadersSize);
            httpRequest.setSecure(isSecureLocal);
            HttpResponsePacketImpl response = HttpResponsePacketImpl.create();
            response.setUpgrade(httpRequest.getUpgrade());
            response.setSecure(isSecureLocal);
            httpRequest.setResponse(response);
            response.setRequest(httpRequest);
            if (this.processKeepAlive) {
                KeepAliveContext keepAliveContext = (KeepAliveContext)this.keepAliveContextAttr.get((AttributeStorage)connection);
                if (keepAliveContext == null) {
                    keepAliveContext = new KeepAliveContext(connection);
                    this.keepAliveContextAttr.set((AttributeStorage)connection, (Object)keepAliveContext);
                }
                keepAliveContext.request = httpRequest;
                int requestsProcessed = keepAliveContext.requestsProcessed;
                if (requestsProcessed > 0) {
                    KeepAlive.notifyProbesHit(this.keepAlive, connection, requestsProcessed);
                }
                if (this.keepAliveQueue != null) {
                    this.keepAliveQueue.remove((Object)keepAliveContext);
                }
            }
            this.httpRequestInProcessAttr.set((AttributeStorage)connection, (Object)httpRequest);
        } else if (httpRequest.isContentBroken()) {
            return ctx.getStopAction();
        }
        return this.handleRead(ctx, httpRequest);
    }

    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        Connection c = ctx.getConnection();
        if (event.type() == RESPONSE_COMPLETE_EVENT.type() && c.isOpen()) {
            if (this.processKeepAlive) {
                KeepAliveContext keepAliveContext = (KeepAliveContext)this.keepAliveContextAttr.get((AttributeStorage)c);
                if (this.keepAliveQueue != null) {
                    this.keepAliveQueue.add((Object)keepAliveContext, (long)this.keepAlive.getIdleTimeoutInSeconds(), TimeUnit.SECONDS);
                }
                HttpRequestPacket httpRequest = keepAliveContext.request;
                boolean isStayAlive = this.isKeepAlive(httpRequest, keepAliveContext);
                keepAliveContext.request = null;
                this.processResponseComplete(ctx, httpRequest, isStayAlive);
            } else {
                HttpRequestPacketImpl httpRequest = this.getHttpRequestInProcess(c);
                if (httpRequest != null) {
                    this.processResponseComplete(ctx, httpRequest, false);
                }
                HttpServerFilter.flushAndClose(ctx);
            }
            return ctx.getStopAction();
        }
        return ctx.getInvokeAction();
    }

    private void processResponseComplete(FilterChainContext ctx, HttpRequestPacket httpRequest, boolean isStayAlive) throws IOException {
        boolean hasTransferEncoding;
        boolean bl = hasTransferEncoding = httpRequest.getTransferEncoding() != null;
        if (httpRequest.isExpectContent()) {
            if (hasTransferEncoding && !httpRequest.isContentBroken()) {
                httpRequest.setSkipRemainder(true);
            } else {
                httpRequest.setExpectContent(false);
                this.onHttpPacketParsed(httpRequest, ctx);
                HttpServerFilter.flushAndClose(ctx);
            }
        } else if (!isStayAlive) {
            HttpServerFilter.flushAndClose(ctx);
        }
    }

    @Override
    protected boolean onHttpHeaderParsed(HttpHeader httpHeader, Buffer buffer, FilterChainContext ctx) {
        HttpRequestPacketImpl request = (HttpRequestPacketImpl)httpHeader;
        if (!request.getUpgradeDC().isNull()) {
            return false;
        }
        this.prepareRequest(request, buffer.hasRemaining());
        return request.getProcessingState().error;
    }

    @Override
    protected final boolean onHttpPacketParsed(HttpHeader httpHeader, FilterChainContext ctx) {
        HttpRequestPacketImpl request = (HttpRequestPacketImpl)httpHeader;
        boolean error = request.getProcessingState().error;
        if (!error) {
            this.httpRequestInProcessAttr.remove((AttributeStorage)ctx.getConnection());
        }
        return error;
    }

    @Override
    protected void onInitialLineParsed(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    @Override
    protected void onInitialLineEncoded(HttpHeader header, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpHeadersParsed(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpHeadersEncoded(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpContentParsed(HttpContent content, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpContentEncoded(HttpContent content, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpHeaderError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
        HttpRequestPacketImpl request = (HttpRequestPacketImpl)httpHeader;
        HttpResponsePacket response = request.getResponse();
        if (response.getHttpStatus().getStatusCode() < 400) {
            HttpStatus.BAD_REQUEST_400.setValues(response);
        }
        HttpContent errorHttpResponse = this.customizeErrorResponse(response);
        Buffer resBuf = this.encodeHttpPacket(ctx, errorHttpResponse);
        ctx.write((Object)resBuf);
        ctx.flush(FLUSH_AND_CLOSE_HANDLER);
    }

    @Override
    protected void onHttpContentError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
        httpHeader.setContentBroken(true);
    }

    @Override
    protected Buffer encodeHttpPacket(FilterChainContext ctx, HttpPacket input) {
        HttpContent encodedHttpContent;
        HttpContent content;
        HttpHeader header;
        boolean isHeaderPacket = input.isHeader();
        if (isHeaderPacket) {
            header = (HttpHeader)input;
            content = null;
        } else {
            content = (HttpContent)input;
            header = content.getHttpHeader();
        }
        boolean wasContentAlreadyEncoded = false;
        HttpResponsePacketImpl response = (HttpResponsePacketImpl)header;
        if (!response.isCommitted() && response.getUpgrade() == null && (encodedHttpContent = this.prepareResponse(ctx.getConnection(), response.getRequest(), response, content)) != null) {
            content = encodedHttpContent;
            wasContentAlreadyEncoded = true;
        }
        Buffer encoded = super.encodeHttpPacket(ctx, header, content, wasContentAlreadyEncoded);
        if (!isHeaderPacket) {
            input.recycle();
        }
        return encoded;
    }

    @Override
    final boolean decodeInitialLine(FilterChainContext ctx, HttpPacketParsing httpPacket, HttpCodecFilter.HeaderParsingState parsingState, Buffer input) {
        HttpRequestPacketImpl httpRequest = (HttpRequestPacketImpl)httpPacket;
        int reqLimit = parsingState.packetLimit;
        int subState = parsingState.subState++;
        switch (subState) {
            case 0: {
                int spaceIdx = HttpServerFilter.findSpace(input, parsingState.offset, reqLimit);
                if (spaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                httpRequest.getMethodDC().setBuffer(input, parsingState.start, spaceIdx);
                parsingState.start = -1;
                parsingState.offset = spaceIdx;
            }
            case 1: {
                int nonSpaceIdx = HttpServerFilter.skipSpaces(input, parsingState.offset, reqLimit);
                if (nonSpaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                parsingState.start = nonSpaceIdx;
                parsingState.offset = nonSpaceIdx + 1;
                ++parsingState.subState;
            }
            case 2: {
                if (!HttpServerFilter.parseRequestURI(httpRequest, parsingState, input)) {
                    return false;
                }
            }
            case 3: {
                int nonSpaceIdx = HttpServerFilter.skipSpaces(input, parsingState.offset, reqLimit);
                if (nonSpaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                parsingState.start = nonSpaceIdx;
                parsingState.offset = nonSpaceIdx;
                ++parsingState.subState;
            }
            case 4: {
                if (!HttpServerFilter.findEOL(parsingState, input)) {
                    parsingState.offset = input.limit();
                    return false;
                }
                if (parsingState.checkpoint > parsingState.start) {
                    httpRequest.getProtocolDC().setBuffer(input, parsingState.start, parsingState.checkpoint);
                } else {
                    httpRequest.getProtocolDC().setString("");
                }
                parsingState.subState = 0;
                parsingState.start = -1;
                parsingState.checkpoint = -1;
                this.onInitialLineParsed(httpRequest, ctx);
                return true;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    Buffer encodeInitialLine(HttpPacket httpPacket, Buffer output, MemoryManager memoryManager) {
        HttpResponsePacket httpResponse = (HttpResponsePacket)httpPacket;
        output = HttpCodecUtils.put(memoryManager, output, httpResponse.getProtocol().getProtocolBytes());
        output = HttpCodecUtils.put(memoryManager, output, (byte)32);
        output = HttpCodecUtils.put(memoryManager, output, httpResponse.getHttpStatus().getStatusBytes());
        output = HttpCodecUtils.put(memoryManager, output, (byte)32);
        output = httpResponse.isCustomReasonPhraseSet() ? HttpCodecUtils.put(memoryManager, output, HttpStatus.filter(httpResponse.getReasonPhraseDC())) : HttpCodecUtils.put(memoryManager, output, httpResponse.getHttpStatus().getReasonPhraseBytes());
        return output;
    }

    private static boolean parseRequestURI(HttpRequestPacketImpl httpRequest, HttpCodecFilter.HeaderParsingState state, Buffer input) {
        int offset;
        int limit = Math.min(input.limit(), state.packetLimit);
        boolean found = false;
        for (offset = state.offset; offset < limit; ++offset) {
            byte b = input.get(offset);
            if (b == 32 || b == 9) {
                found = true;
                break;
            }
            if (b == 13 || b == 10) {
                found = true;
                break;
            }
            if (b != 63 || state.checkpoint != -1) continue;
            state.checkpoint = offset;
        }
        if (found) {
            int requestURIEnd = offset;
            if (state.checkpoint != -1) {
                requestURIEnd = state.checkpoint;
                httpRequest.getQueryStringDC().setBuffer(input, state.checkpoint + 1, offset);
            }
            httpRequest.getRequestURIRef().init(input, state.start, requestURIEnd);
            state.start = -1;
            state.checkpoint = -1;
            ++state.subState;
        }
        state.offset = offset;
        return found;
    }

    private HttpContent prepareResponse(Connection connection, HttpRequestPacket request, HttpResponsePacketImpl response, HttpContent httpContent) {
        Method method;
        Protocol requestProtocol = request.getProtocol();
        response.setProtocol(Protocol.HTTP_1_1);
        if (requestProtocol == Protocol.HTTP_0_9) {
            return null;
        }
        boolean entityBody = true;
        int statusCode = response.getStatus();
        if (statusCode == 204 || statusCode == 205 || statusCode == 304) {
            entityBody = false;
            response.setExpectContent(false);
        }
        boolean isHttp11 = requestProtocol == Protocol.HTTP_1_1;
        this.setContentEncodingsOnSerializing(response);
        HttpContent encodedHttpContent = null;
        long contentLength = response.getContentLength();
        if (entityBody && contentLength == -1L && !response.isChunked()) {
            if (httpContent != null && httpContent.isLast()) {
                if (!response.getContentEncodings(true).isEmpty()) {
                    encodedHttpContent = this.encodeContent(connection, httpContent);
                }
                response.setContentLength(httpContent.getContent().remaining());
            } else if (this.chunkingEnabled && isHttp11) {
                response.setChunked(true);
            }
        }
        if (Method.HEAD.equals(method = request.getMethod())) {
            response.setExpectContent(false);
        }
        MimeHeaders headers = response.getHeaders();
        if (!entityBody) {
            response.setContentLength(-1);
        } else {
            String contentLanguage = response.getContentLanguage();
            if (contentLanguage != null) {
                headers.setValue(Header.ContentLanguage).setString(contentLanguage);
            }
            if (!response.isContentTypeSet() && this.defaultResponseContentType != null) {
                response.setDefaultContentType(this.defaultResponseContentType);
            }
        }
        if (!response.containsHeader(Header.Date)) {
            String date = FastHttpDateFormat.getCurrentDate();
            response.addHeader(Header.Date, date);
        }
        ProcessingState state = response.getProcessingState();
        if (entityBody && !isHttp11 && response.getContentLength() == -1L) {
            state.keepAlive = false;
        } else if (entityBody && !response.isChunked() && response.getContentLength() == -1L) {
            state.keepAlive = false;
        } else if (!this.checkKeepAliveRequestsCount(request.getConnection())) {
            state.keepAlive = false;
        }
        boolean bl = state.keepAlive = state.keepAlive && !HttpServerFilter.statusDropsConnection(response.getStatus());
        if (!state.keepAlive) {
            headers.setValue(Header.Connection).setString("close");
        } else if (!isHttp11 && !state.error) {
            headers.setValue(Header.Connection).setString("Keep-Alive");
        }
        return encodedHttpContent;
    }

    private void prepareRequest(HttpRequestPacketImpl request, boolean hasReadyContent) {
        boolean isConnectionClose;
        Protocol protocol2;
        ProcessingState state = request.getProcessingState();
        HttpResponsePacket response = request.getResponse();
        Method method = request.getMethod();
        if (Method.GET.equals(method) || Method.HEAD.equals(method) || !request.containsHeader(Header.TransferEncoding) && request.getContentLength() == -1L) {
            request.setExpectContent(false);
        }
        try {
            protocol2 = request.getProtocol();
        }
        catch (IllegalStateException e) {
            state.error = true;
            HttpStatus.HTTP_VERSION_NOT_SUPPORTED_505.setValues(response);
            Protocol protocol2 = Protocol.HTTP_1_1;
            request.setProtocol(protocol2);
            return;
        }
        if (request.getHeaderParsingState().contentLengthsDiffer) {
            request.getProcessingState().error = true;
            return;
        }
        MimeHeaders headers = request.getHeaders();
        DataChunk hostDC = null;
        BufferChunk uriBC = request.getRequestURIRef().getRequestURIBC().getBufferChunk();
        if (uriBC.startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 4);
            int uriBCStart = uriBC.getStart();
            if (pos != -1) {
                Buffer uriB = uriBC.getBuffer();
                int slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    uriBC.setBufferChunk(uriB, uriBCStart + pos + 1, uriBCStart + pos + 2);
                } else {
                    uriBC.setBufferChunk(uriB, uriBCStart + slashPos, uriBC.getEnd());
                }
                hostDC = headers.setValue("host");
                hostDC.setBuffer(uriB, uriBCStart + pos + 3, uriBCStart + slashPos);
            }
        }
        boolean isHttp11 = protocol2 == Protocol.HTTP_1_1;
        DataChunk connectionValueDC = headers.getValue(Header.Connection);
        boolean bl = isConnectionClose = connectionValueDC != null && connectionValueDC.getBufferChunk().equalsIgnoreCaseLowerCase(CLOSE_BYTES);
        if (!isConnectionClose) {
            boolean bl2 = state.keepAlive = isHttp11 || connectionValueDC != null && connectionValueDC.getBufferChunk().equalsIgnoreCaseLowerCase(KEEPALIVE_BYTES);
        }
        if (hostDC == null) {
            hostDC = headers.getValue(Header.Host);
        }
        if (hostDC == null && isHttp11) {
            state.error = true;
            return;
        }
        HttpServerFilter.parseHost(hostDC, request, response, state);
        if (isHttp11 && request.serverName().getLength() == 0) {
            state.error = true;
            return;
        }
        if (request.requiresAcknowledgement()) {
            request.requiresAcknowledgement(isHttp11 && !hasReadyContent);
        }
        request.getResponse().setChunkingAllowed(this.isChunkingEnabled());
    }

    protected HttpContent customizeErrorResponse(HttpResponsePacket response) {
        response.setContentLength(0);
        return ((HttpContent.Builder)HttpContent.builder(response).last(true)).build();
    }

    private static boolean statusDropsConnection(int status) {
        return status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 417 || status == 500 || status == 503 || status == 501 || status == 505;
    }

    private static void parseHost(DataChunk hostDC, HttpRequestPacket request, HttpResponsePacket response, ProcessingState state) {
        if (hostDC == null) {
            Connection connection = request.getConnection();
            request.setServerPort(((InetSocketAddress)connection.getLocalAddress()).getPort());
            InetAddress localAddress = ((InetSocketAddress)connection.getLocalAddress()).getAddress();
            request.setLocalHost(localAddress.getHostName());
            request.serverName().setString(localAddress.getHostName());
            return;
        }
        BufferChunk valueBC = hostDC.getBufferChunk();
        int valueS = valueBC.getStart();
        int valueL = valueBC.getEnd() - valueS;
        int colonPos = -1;
        Buffer valueB = valueBC.getBuffer();
        boolean ipv6 = valueB.get(valueS) == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            byte b = valueB.get(i + valueS);
            if (b == 93) {
                bracketClosed = true;
                continue;
            }
            if (b != 58 || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (!request.isSecure()) {
                request.setServerPort(80);
            } else {
                request.setServerPort(443);
            }
            request.serverName().setBuffer(valueB, valueS, valueS + valueL);
        } else {
            request.serverName().setBuffer(valueB, valueS, valueS + colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = DEC[valueB.get(i + valueS)];
                if (charValue == -1) {
                    state.error = true;
                    HttpStatus.BAD_REQUEST_400.setValues(response);
                    return;
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            request.setServerPort(port);
        }
    }

    private boolean isKeepAlive(HttpRequestPacket request, KeepAliveContext keepAliveContext) {
        boolean isKeepAlive = request.getProcessingState().isStayAlive();
        if (isKeepAlive && keepAliveContext != null && keepAliveContext.requestsProcessed == 1) {
            if (isKeepAlive) {
                KeepAlive.notifyProbesConnectionAccepted(this.keepAlive, keepAliveContext.connection);
            } else {
                KeepAlive.notifyProbesRefused(this.keepAlive, keepAliveContext.connection);
            }
        }
        return isKeepAlive;
    }

    private HttpRequestPacketImpl getHttpRequestInProcess(Connection connection) {
        return (HttpRequestPacketImpl)this.httpRequestInProcessAttr.get((AttributeStorage)connection);
    }

    private boolean checkKeepAliveRequestsCount(Connection connection) {
        boolean firstCheck;
        KeepAliveContext keepAliveContext = (KeepAliveContext)this.keepAliveContextAttr.get((AttributeStorage)connection);
        boolean bl = firstCheck = this.processKeepAlive && keepAliveContext != null;
        if (!firstCheck) {
            return true;
        }
        keepAliveContext.requestsProcessed++;
        int maxRequestCount = this.keepAlive.getMaxRequestsCount();
        return maxRequestCount == -1 || keepAliveContext.requestsProcessed <= maxRequestCount;
    }

    public String getDefaultResponseContentType() {
        return this.defaultResponseContentType;
    }

    public void setDefaultResponseContentType(String defaultResponseContentType) {
        this.defaultResponseContentType = defaultResponseContentType;
    }

    private static class KeepAliveResolver
    implements DelayedExecutor.Resolver<KeepAliveContext> {
        private KeepAliveResolver() {
        }

        public boolean removeTimeout(KeepAliveContext context) {
            if (context.keepAliveTimeoutMillis != -1L) {
                context.keepAliveTimeoutMillis = -1L;
                return true;
            }
            return false;
        }

        public Long getTimeoutMillis(KeepAliveContext element) {
            return element.keepAliveTimeoutMillis;
        }

        public void setTimeoutMillis(KeepAliveContext element, long timeoutMillis) {
            element.keepAliveTimeoutMillis = timeoutMillis;
        }
    }

    private static class KeepAliveWorker
    implements DelayedExecutor.Worker<KeepAliveContext> {
        private final KeepAlive keepAlive;

        public KeepAliveWorker(KeepAlive keepAlive) {
            this.keepAlive = keepAlive;
        }

        public boolean doWork(KeepAliveContext context) {
            KeepAlive.notifyProbesTimeout(this.keepAlive, context.connection);
            context.connection.closeSilently();
            return true;
        }
    }

    private static class KeepAliveContext {
        private final Connection connection;
        private volatile long keepAliveTimeoutMillis = -1L;
        private int requestsProcessed;
        private HttpRequestPacket request;

        public KeepAliveContext(Connection connection) {
            this.connection = connection;
        }
    }
}

