/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import java.util.Collection;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.servlet.DispatcherType;
import org.glassfish.grizzly.servlet.FilterChainImpl;
import org.glassfish.grizzly.servlet.FilterRegistration;
import org.glassfish.grizzly.servlet.WebappContext;

public class FilterChainFactory {
    private final Collection<FilterRegistration> registrations;
    private final WebappContext ctx;

    public FilterChainFactory(WebappContext ctx, Collection<FilterRegistration> registrations) {
        this.ctx = ctx;
        this.registrations = registrations;
    }

    public FilterChainImpl createFilterChain(ServletRequest request, Servlet servlet, DispatcherType dispatcherType) {
        return this.buildFilterChain(servlet, this.getRequestPath(request), dispatcherType);
    }

    public FilterChainImpl createFilterChain(Request request, Servlet servlet, DispatcherType dispatcherType) {
        return this.buildFilterChain(servlet, this.getRequestPath(request), dispatcherType);
    }

    private FilterChainImpl buildFilterChain(Servlet servlet, String requestPath, DispatcherType dispatcherType) {
        if (servlet == null) {
            return null;
        }
        FilterChainImpl filterChain = new FilterChainImpl(servlet, this.ctx);
        if (this.registrations.isEmpty()) {
            return filterChain;
        }
        for (FilterRegistration registration : this.registrations) {
            for (Map.Entry<String[], Byte> entry : registration.urlPatterns.entrySet()) {
                if (!registration.isDispatcherSet(entry.getValue(), dispatcherType) || !FilterChainFactory.matchFiltersURL(entry.getKey(), requestPath)) continue;
                filterChain.addFilter(registration);
            }
        }
        String servletName = servlet.getServletConfig().getServletName();
        for (FilterRegistration registration : this.registrations) {
            for (Map.Entry<String[], Byte> entry : registration.urlPatterns.entrySet()) {
                if (!registration.isDispatcherSet(entry.getValue(), dispatcherType) || !this.matchFiltersServlet(entry.getKey(), servletName)) continue;
                filterChain.addFilter(registration);
            }
        }
        return filterChain;
    }

    private String getRequestPath(ServletRequest request) {
        String requestPath = null;
        Object attribute = request.getAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH");
        if (attribute != null) {
            requestPath = attribute.toString();
        }
        return requestPath;
    }

    private String getRequestPath(Request request) {
        String requestPath = null;
        Object attribute = request.getAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH");
        if (attribute != null) {
            requestPath = attribute.toString();
        }
        return requestPath;
    }

    private static boolean matchFiltersURL(String[] urlPatterns, String requestPath) {
        if (requestPath == null) {
            return false;
        }
        if (urlPatterns == null || urlPatterns.length == 0) {
            return false;
        }
        for (String urlPattern : urlPatterns) {
            if (urlPattern.equals(requestPath)) {
                return true;
            }
            if ("/*".equals(urlPattern)) {
                return true;
            }
            if (urlPattern.endsWith("/*")) {
                if (!urlPattern.regionMatches(0, requestPath, 0, urlPattern.length() - 2)) continue;
                if (requestPath.length() == urlPattern.length() - 2) {
                    return true;
                }
                if ('/' != requestPath.charAt(urlPattern.length() - 2)) continue;
                return true;
            }
            if (!urlPattern.startsWith("*.")) continue;
            int slash = requestPath.lastIndexOf(47);
            int period = requestPath.lastIndexOf(46);
            if (slash < 0 || period <= slash || period == requestPath.length() - 1 || requestPath.length() - period != urlPattern.length() - 1) continue;
            return urlPattern.regionMatches(2, requestPath, period + 1, urlPattern.length() - 2);
        }
        return false;
    }

    private boolean matchFiltersServlet(String[] servletNames, String servletName) {
        if (servletName != null) {
            if (servletNames == null || servletNames.length == 0) {
                return false;
            }
            for (String name : servletNames) {
                if (!servletName.equals(name) && !"*".equals(name)) continue;
                return true;
            }
        }
        return false;
    }
}

