/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.servlet.CookieWrapper;
import org.glassfish.grizzly.servlet.ServletOutputStreamImpl;
import org.glassfish.grizzly.servlet.ServletWriterImpl;

public class HttpServletResponseImpl
implements HttpServletResponse {
    private final ServletOutputStreamImpl outputStream = new ServletOutputStreamImpl();
    private ServletWriterImpl writer;
    protected boolean usingOutputStream = false;
    protected boolean usingWriter = false;
    private static final ThreadCache.CachedTypeIndex<HttpServletResponseImpl> CACHE_IDX = ThreadCache.obtainIndex(HttpServletResponseImpl.class, (int)2);
    protected Response response = null;

    public static HttpServletResponseImpl create() {
        HttpServletResponseImpl response = (HttpServletResponseImpl)ThreadCache.takeFromCache(CACHE_IDX);
        if (response != null) {
            return response;
        }
        return new HttpServletResponseImpl();
    }

    protected HttpServletResponseImpl() {
    }

    public void initialize(Response response) throws IOException {
        this.response = response;
        this.outputStream.initialize(response);
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void finish() throws IOException {
        if (this.response == null) {
            throw new IllegalStateException("Null response object");
        }
        this.response.finish();
    }

    public String getCharacterEncoding() {
        if (this.response == null) {
            throw new IllegalStateException("Null response object");
        }
        return this.response.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.usingWriter) {
            throw new IllegalStateException("Illegal attempt to call getOutputStream() after getWriter() has already been called.");
        }
        this.usingOutputStream = true;
        return this.outputStream;
    }

    void recycle() {
        this.response = null;
        this.writer = null;
        this.outputStream.recycle();
        this.usingOutputStream = false;
        this.usingWriter = false;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.usingOutputStream) {
            throw new IllegalStateException("Illegal attempt to call getWriter() after getOutputStream has already been called.");
        }
        this.usingWriter = true;
        if (this.writer == null) {
            this.writer = new ServletWriterImpl(this.response.getWriter());
        }
        return this.writer;
    }

    public void setContentLength(int len) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLength(len);
    }

    public void setContentType(String type) {
        if (this.isCommitted()) {
            return;
        }
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new SetContentTypePrivilegedAction(type));
        } else {
            this.response.setContentType(type);
        }
    }

    public void setBufferSize(int size) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Illegal attempt to adjust the buffer size after the response has already been committed.");
        }
        this.response.setBufferSize(size);
    }

    public int getBufferSize() {
        if (this.response == null) {
            throw new IllegalStateException("Null response object");
        }
        return this.response.getBufferSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void flushBuffer() throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        HttpServletResponseImpl.this.response.flush();
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (!(ex instanceof IOException)) return;
                throw (IOException)ex;
            }
        } else {
            this.response.flush();
        }
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Illegal attempt to reset the buffer after the response has already been committed.");
        }
        this.response.resetBuffer();
    }

    public boolean isCommitted() {
        if (this.response == null) {
            throw new IllegalStateException("Null response object");
        }
        return this.response.isCommitted();
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Illegal attempt to reset the response after it has already been committed.");
        }
        this.response.reset();
    }

    public void setLocale(Locale loc) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setLocale(loc);
    }

    public Locale getLocale() {
        if (this.response == null) {
            throw new IllegalStateException("Null response object");
        }
        return this.response.getLocale();
    }

    public void addCookie(javax.servlet.http.Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        CookieWrapper wrapper = new CookieWrapper(cookie.getName(), cookie.getValue());
        wrapper.setWrappedCookie(cookie);
        this.response.addCookie((Cookie)wrapper);
    }

    public boolean containsHeader(String name) {
        if (this.response == null) {
            throw new IllegalStateException("Null response object");
        }
        return this.response.containsHeader(name);
    }

    public String encodeURL(String url) {
        if (this.response == null) {
            throw new IllegalStateException("Null response object");
        }
        return this.response.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        if (this.response == null) {
            throw new IllegalStateException("Null response object");
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String encodeUrl(String url) {
        if (this.response == null) {
            throw new IllegalStateException("Null response object");
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String encodeRedirectUrl(String url) {
        if (this.response == null) {
            throw new IllegalStateException("Null response object");
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void sendError(int sc, String msg) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Illegal attempt to call sendError() after the response has been committed.");
        }
        this.response.sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Illegal attempt to call sendError() after the response has already been committed.");
        }
        this.response.sendError(sc);
    }

    public void sendRedirect(String location) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Illegal attempt to redirect the response after it has been committed.");
        }
        this.response.sendRedirect(location);
    }

    public void setDateHeader(String name, long date) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setDateHeader(name, date);
    }

    public void addDateHeader(String name, long date) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addIntHeader(name, value);
    }

    public void setStatus(int sc) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setStatus(sc);
    }

    public void setStatus(int sc, String sm) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setStatus(sc, sm);
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public String getMessage() {
        return this.response.getMessage();
    }

    public boolean isError() {
        return this.response.isError();
    }

    public String getContentType() {
        return this.response.getContentType();
    }

    public void setCharacterEncoding(String charEnc) {
        this.response.setCharacterEncoding(charEnc);
    }

    protected Response getResponse() {
        return this.response;
    }

    private final class SetContentTypePrivilegedAction
    implements PrivilegedAction {
        private final String contentType;

        public SetContentTypePrivilegedAction(String contentType) {
            this.contentType = contentType;
        }

        public Object run() {
            HttpServletResponseImpl.this.response.setContentType(this.contentType);
            return null;
        }
    }
}

