/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.server.AfterServiceListener;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.util.ClassLoaderUtil;
import org.glassfish.grizzly.http.server.util.IntrospectionUtils;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.HttpRequestURIDecoder;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.servlet.FilterConfigImpl;
import org.glassfish.grizzly.servlet.HttpServletRequestImpl;
import org.glassfish.grizzly.servlet.HttpServletResponseImpl;
import org.glassfish.grizzly.servlet.ServletConfigImpl;
import org.glassfish.grizzly.servlet.ServletContextImpl;

public class ServletHandler
extends HttpHandler {
    private static final Logger LOGGER = Grizzly.logger(ServletHandler.class);
    static final Request.Note<HttpServletRequestImpl> SERVLET_REQUEST_NOTE = Request.createNote((String)HttpServletRequestImpl.class.getName());
    static final Request.Note<HttpServletResponseImpl> SERVLET_RESPONSE_NOTE = Request.createNote((String)HttpServletResponseImpl.class.getName());
    static final ServletAfterServiceListener servletAfterServiceListener = new ServletAfterServiceListener();
    public static final String LOAD_ON_STARTUP = "load-on-startup";
    protected volatile Servlet servletInstance = null;
    private transient List<String> listeners = new ArrayList<String>();
    private String servletPath = "";
    private String contextPath = "";
    private boolean loadOnStartup = false;
    private Map<String, String> contextParameters = new HashMap<String, String>();
    private Map<String, String> servletInitParameters = new HashMap<String, String>();
    private volatile boolean filterChainConfigured = false;
    private ReentrantLock filterChainReady = new ReentrantLock();
    private final ServletContextImpl servletCtx;
    private ServletConfigImpl servletConfig;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected boolean initialize = true;
    protected ClassLoader classLoader;
    private static final Object[] lock = new Object[0];
    private FilterConfigImpl[] filters = new FilterConfigImpl[8];
    public static final int INCREMENT = 8;
    private int n = 0;

    public ServletHandler() {
        this(new ServletContextImpl(), new HashMap<String, String>(), new HashMap<String, String>(), new ArrayList<String>());
    }

    public ServletHandler(Servlet servlet) {
        this();
        this.servletInstance = servlet;
    }

    protected ServletHandler(ServletContextImpl servletCtx, Map<String, String> contextParameters, Map<String, String> servletInitParameters, List<String> listeners) {
        this(servletCtx, contextParameters, servletInitParameters, listeners, true);
    }

    protected ServletHandler(ServletContextImpl servletCtx, Map<String, String> contextParameters, Map<String, String> servletInitParameters, List<String> listeners, boolean initialize) {
        this.servletCtx = servletCtx;
        this.servletConfig = new ServletConfigImpl(servletCtx, servletInitParameters);
        this.contextParameters = contextParameters;
        this.servletInitParameters = servletInitParameters;
        this.listeners = listeners;
        this.initialize = initialize;
    }

    protected ServletHandler(ServletContextImpl servletCtx, Map<String, String> contextParameters, Map<String, String> servletInitParameters, boolean initialize) {
        this.servletCtx = servletCtx;
        this.servletConfig = new ServletConfigImpl(servletCtx, servletInitParameters);
        this.contextParameters = contextParameters;
        this.servletInitParameters = servletInitParameters;
        this.initialize = initialize;
    }

    public ServletHandler(Servlet servlet, ServletContextImpl servletContext) {
        this.servletInstance = servlet;
        this.servletCtx = servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        block9: {
            try {
                this.configureServletEnv();
                if (this.initialize) {
                    this.configureClassLoader(new File(this.servletCtx.getBasePath()).getCanonicalPath());
                }
                if (this.classLoader != null) {
                    ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.classLoader);
                    try {
                        if (this.loadOnStartup) {
                            this.loadServlet();
                        }
                        break block9;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(prevClassLoader);
                    }
                }
                if (this.loadOnStartup) {
                    this.loadServlet();
                }
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "start", t);
            }
        }
    }

    protected void configureClassLoader(String applicationPath) throws IOException {
        if (this.classLoader == null) {
            this.classLoader = ClassLoaderUtil.createURLClassLoader((String)applicationPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request request, Response response) {
        if (this.classLoader != null) {
            ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                this.doServletService(request, response);
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevClassLoader);
            }
        } else {
            this.doServletService(request, response);
        }
    }

    protected void doServletService(Request request, Response response) {
        try {
            String uri = request.getRequestURI();
            if (!uri.startsWith(this.contextPath)) {
                this.customizeErrorPage(response, "Resource Not Found", 404);
                return;
            }
            HttpServletRequestImpl servletRequest = HttpServletRequestImpl.create();
            HttpServletResponseImpl servletResponse = HttpServletResponseImpl.create();
            servletRequest.initialize(request);
            servletResponse.initialize(response);
            request.setNote(SERVLET_REQUEST_NOTE, (Object)servletRequest);
            request.setNote(SERVLET_RESPONSE_NOTE, (Object)servletResponse);
            request.addAfterServiceListener((AfterServiceListener)servletAfterServiceListener);
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie c : cookies) {
                    if (!"JSESSIONID".equals(c.getName())) continue;
                    request.setRequestedSessionId(c.getValue());
                    request.setRequestedSessionCookie(true);
                    break;
                }
            }
            this.loadServlet();
            servletRequest.setContextImpl(this.servletCtx);
            servletRequest.setServletPath(this.servletPath);
            servletRequest.initSession();
            servletResponse.addHeader("server", "grizzly/" + Grizzly.getDotedVersion());
            FilterChainImpl filterChain = new FilterChainImpl(this.servletInstance, this.servletConfig);
            filterChain.invokeFilterChain((ServletRequest)servletRequest, (ServletResponse)servletResponse);
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, "service exception:", ex);
            this.customizeErrorPage(response, "Internal Error", 500);
        }
    }

    public void customizeErrorPage(Response response, String message, int errorCode) {
        response.setStatus(errorCode, message);
        response.setContentType("text/html");
        try {
            response.getWriter().write("<html><body><h1>" + message + "</h1></body></html>");
            response.getWriter().flush();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadServlet() throws ServletException {
        try {
            this.filterChainReady.lock();
            if (this.filterChainConfigured) {
                return;
            }
            if (this.servletInstance == null) {
                String servletClassName = System.getProperty("com.sun.grizzly.servletClass");
                if (servletClassName != null) {
                    this.servletInstance = (Servlet)ClassLoaderUtil.load((String)servletClassName);
                }
                if (this.servletInstance != null) {
                    LOGGER.log(Level.INFO, "Loading Servlet: {0}", this.servletInstance.getClass().getName());
                }
            }
            if (this.servletInstance != null) {
                this.servletInstance.init((ServletConfig)this.servletConfig);
            }
            for (FilterConfigImpl f : this.filters) {
                if (f == null) continue;
                f.getFilter().init((FilterConfig)f);
            }
            this.filterChainConfigured = true;
        }
        finally {
            this.filterChainReady.unlock();
        }
    }

    protected void configureServletEnv() throws ServletException {
        if (this.contextPath.length() > 0) {
            CharChunk cc = new CharChunk();
            char[] ch = this.contextPath.toCharArray();
            cc.setChars(ch, 0, ch.length);
            HttpRequestURIDecoder.normalizeChars((CharChunk)cc);
            this.contextPath = cc.toString();
        }
        if ("/".equals(this.contextPath)) {
            this.contextPath = "";
        }
        if (this.initialize) {
            this.servletCtx.setInitParameter(this.contextParameters);
            this.servletCtx.setContextPath(this.contextPath);
            this.servletCtx.setBasePath(".");
            this.configureProperties(this.servletCtx);
            this.servletCtx.initListeners(this.listeners);
        }
        this.servletConfig.setInitParameters(this.servletInitParameters);
        this.configureProperties(this.servletConfig);
    }

    public void addInitParameter(String name, String value) {
        this.servletInitParameters.put(name, value);
    }

    public void removeInitParameter(String name) {
        this.servletInitParameters.remove(name);
    }

    public String getInitParameter(String name) {
        return this.servletInitParameters.get(name);
    }

    public boolean containsInitParameter(String name) {
        return this.servletInitParameters.containsKey(name);
    }

    public void addContextParameter(String name, String value) {
        this.contextParameters.put(name, value);
    }

    public void addFilter(Filter filter, String filterName, Map initParameters) {
        FilterConfigImpl filterConfig = new FilterConfigImpl(this.servletCtx);
        filterConfig.setFilter(filter);
        filterConfig.setFilterName(filterName);
        filterConfig.setInitParameters(initParameters);
        this.addFilter(filterConfig);
    }

    public Servlet getServletInstance() {
        return this.servletInstance;
    }

    public void setServletInstance(Servlet servletInstance) {
        this.servletInstance = servletInstance;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
        if (!servletPath.equals("") && !servletPath.startsWith("/")) {
            servletPath = "/" + servletPath;
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void addServletListener(String listenerName) {
        if (listenerName == null) {
            return;
        }
        this.listeners.add(listenerName);
    }

    public boolean removeServletListener(String listenerName) {
        return listenerName != null && this.listeners.remove(listenerName);
    }

    private void configureProperties(Object object) {
        for (String s : this.properties.keySet()) {
            String value = this.properties.get(s).toString();
            IntrospectionUtils.setProperty((Object)object, (String)s, (String)value);
        }
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        int pos;
        if (name.equalsIgnoreCase(LOAD_ON_STARTUP) && value != null) {
            if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                this.loadOnStartup = true;
            } else {
                try {
                    if (new Integer(value.toString()) >= 0) {
                        this.loadOnStartup = true;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if ((pos = name.indexOf("-")) > 0) {
            String pre = name.substring(0, pos);
            String post = name.substring(pos + 1, pos + 2).toUpperCase() + name.substring(pos + 2);
            name = pre + post;
        }
        this.properties.put(name, value);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public boolean isLoadOnStartup() {
        return this.loadOnStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.classLoader != null) {
            ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                super.destroy();
                this.servletCtx.destroyListeners();
                for (FilterConfigImpl filter : this.filters) {
                    if (filter == null) continue;
                    filter.recycle();
                }
                if (this.servletInstance != null) {
                    this.servletInstance.destroy();
                    this.servletInstance = null;
                }
                this.filters = null;
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevClassLoader);
            }
        } else {
            super.destroy();
            this.servletCtx.destroyListeners();
        }
    }

    public ServletHandler newServletHandler(Servlet servlet) {
        ServletHandler sa = new ServletHandler(this.servletCtx, this.contextParameters, new HashMap<String, String>(), this.listeners, false);
        if (this.classLoader != null) {
            sa.setClassLoader(this.classLoader);
        }
        sa.setServletInstance(servlet);
        sa.setServletPath(this.servletPath);
        return sa;
    }

    protected ServletContextImpl getServletCtx() {
        return this.servletCtx;
    }

    protected List<String> getListeners() {
        return this.listeners;
    }

    protected Map<String, String> getContextParameters() {
        return this.contextParameters;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFilter(FilterConfigImpl filterConfig) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.n == this.filters.length) {
                FilterConfigImpl[] newFilters = new FilterConfigImpl[this.n + 8];
                System.arraycopy(this.filters, 0, newFilters, 0, this.n);
                this.filters = newFilters;
            }
            this.filters[this.n++] = filterConfig;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static final class ServletAfterServiceListener
    implements AfterServiceListener {
        ServletAfterServiceListener() {
        }

        public void onAfterService(Request request) {
            HttpServletRequestImpl servletRequest = (HttpServletRequestImpl)request.getNote(SERVLET_REQUEST_NOTE);
            HttpServletResponseImpl servletResponse = (HttpServletResponseImpl)request.getNote(SERVLET_RESPONSE_NOTE);
            if (servletRequest != null) {
                servletRequest.recycle();
                servletResponse.recycle();
            }
        }
    }

    private final class FilterChainImpl
    implements FilterChain {
        private final Servlet servlet;
        private final ServletConfigImpl configImpl;
        private int pos = 0;

        public FilterChainImpl(Servlet servlet, ServletConfigImpl configImpl) {
            this.servlet = servlet;
            this.configImpl = configImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void invokeFilterChain(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            ServletRequestEvent event = new ServletRequestEvent(this.configImpl.getServletContext(), request);
            try {
                for (EventListener l : ((ServletContextImpl)this.configImpl.getServletContext()).getListeners()) {
                    try {
                        if (!(l instanceof ServletRequestListener)) continue;
                        ((ServletRequestListener)l).requestInitialized(event);
                    }
                    catch (Throwable t) {
                        if (!LOGGER.isLoggable(Level.WARNING)) continue;
                        LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_CONTAINER_OBJECT_INITIALIZED_ERROR((Object)"requestInitialized", (Object)"ServletRequestListener", (Object)l.getClass().getName()), t);
                    }
                }
                this.pos = 0;
                this.doFilter(request, response);
            }
            finally {
                for (EventListener l : ((ServletContextImpl)this.configImpl.getServletContext()).getListeners()) {
                    try {
                        if (!(l instanceof ServletRequestListener)) continue;
                        ((ServletRequestListener)l).requestDestroyed(event);
                    }
                    catch (Throwable t) {
                        if (!LOGGER.isLoggable(Level.WARNING)) continue;
                        LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_CONTAINER_OBJECT_DESTROYED_ERROR((Object)"requestDestroyed", (Object)"ServletRequestListener", (Object)l.getClass().getName()), t);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.pos < ServletHandler.this.n) {
                FilterConfigImpl filterConfig;
                Object[] objectArray = lock;
                synchronized (objectArray) {
                    filterConfig = ServletHandler.this.filters[this.pos++];
                }
                try {
                    Filter filter = filterConfig.getFilter();
                    filter.doFilter(request, response, (FilterChain)this);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (ServletException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new ServletException("Throwable", e);
                }
                return;
            }
            try {
                if (this.servlet != null) {
                    this.servlet.service(request, response);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ServletException("Throwable", e);
            }
        }

        protected FilterConfigImpl getFilter(int i) {
            return ServletHandler.this.filters[i];
        }

        protected Servlet getServlet() {
            return this.servlet;
        }

        protected ServletConfigImpl getServletConfig() {
            return this.configImpl;
        }
    }
}

