/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.IOException;
import java.nio.CharBuffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.http.server.io.InputBuffer;
import org.glassfish.grizzly.http.server.io.NIOReader;

final class NIOReaderImpl
extends NIOReader
implements Cacheable {
    private InputBuffer inputBuffer;

    NIOReaderImpl() {
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        return this.inputBuffer.read(target);
    }

    @Override
    public int read() throws IOException {
        return this.inputBuffer.readChar();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.inputBuffer.read(cbuf, 0, cbuf.length);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputBuffer.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        return this.inputBuffer.ready();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.inputBuffer.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        this.inputBuffer.reset();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.inputBuffer.read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.inputBuffer.close();
    }

    @Override
    public void notifyAvailable(ReadHandler handler) {
        this.inputBuffer.notifyAvailable(handler);
    }

    @Override
    public void notifyAvailable(ReadHandler handler, int size) {
        this.inputBuffer.notifyAvailable(handler, size);
    }

    @Override
    public boolean isFinished() {
        return this.inputBuffer.isFinished();
    }

    @Override
    public int readyData() {
        return this.inputBuffer.availableChar();
    }

    @Override
    public boolean isReady() {
        return this.inputBuffer.availableChar() > 0;
    }

    public void recycle() {
        this.inputBuffer = null;
    }

    public void setInputBuffer(InputBuffer inputBuffer) {
        this.inputBuffer = inputBuffer;
    }
}

