/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.IOException;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.Writer;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.filecache.FileCache;

public class FileCacheFilter
extends BaseFilter {
    private final FileCache fileCache;

    public FileCacheFilter(FileCache fileCache) {
        this.fileCache = fileCache;
    }

    public NextAction handleRead(final FilterChainContext ctx) throws IOException {
        HttpPacket response;
        HttpContent requestContent = (HttpContent)ctx.getMessage();
        HttpRequestPacket request = (HttpRequestPacket)requestContent.getHttpHeader();
        if (this.fileCache.isEnabled() && Method.GET.equals(request.getMethod()) && (response = this.fileCache.get(request)) != null) {
            AsyncQueueWriter asyncQueueWriter;
            ctx.write((Object)response);
            Connection connection = ctx.getConnection();
            Writer writer = connection.getTransport().getWriter(connection);
            if (writer instanceof AsyncQueueWriter && !(asyncQueueWriter = (AsyncQueueWriter)writer).canWrite(connection)) {
                NextAction suspendAction = ctx.getSuspendAction();
                ctx.suspend();
                asyncQueueWriter.notifyWritePossible(connection, new WriteHandler(){

                    public void onWritePossible() throws Exception {
                        this.finish();
                    }

                    public void onError(Throwable t) {
                        this.finish();
                    }

                    private void finish() {
                        ctx.resume();
                    }
                });
                return suspendAction;
            }
            return ctx.getStopAction();
        }
        return ctx.getInvokeAction();
    }

    public FileCache getFileCache() {
        return this.fileCache;
    }
}

