/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

public class ServerFilterConfiguration {
    public static final String USE_SEND_FILE = "org.glassfish.grizzly.http.USE_SEND_FILE";
    private String httpServerName;
    private String httpServerVersion;
    private boolean sendFileEnabled;

    public ServerFilterConfiguration() {
        this("Grizzly", "2.1");
    }

    public ServerFilterConfiguration(String serverName, String serverVersion) {
        this.httpServerName = serverName;
        this.httpServerVersion = serverVersion;
        this.configureSendFileSupport();
    }

    public String getHttpServerName() {
        return this.httpServerName;
    }

    public void setHttpServerName(String httpServerName) {
        this.httpServerName = httpServerName;
    }

    public String getHttpServerVersion() {
        return this.httpServerVersion;
    }

    public void setHttpServerVersion(String httpServerVersion) {
        this.httpServerVersion = httpServerVersion;
    }

    public boolean isSendFileEnabled() {
        return this.sendFileEnabled;
    }

    public void setSendFileEnabled(boolean sendFileEnabled) {
        this.sendFileEnabled = sendFileEnabled;
    }

    private void configureSendFileSupport() {
        if (System.getProperty("os.name").equalsIgnoreCase("linux") && !ServerFilterConfiguration.linuxSendFileSupported() || System.getProperty("os.name").equalsIgnoreCase("HP-UX")) {
            this.sendFileEnabled = false;
        }
        if (System.getProperty(USE_SEND_FILE) != null) {
            this.sendFileEnabled = Boolean.valueOf(System.getProperty(USE_SEND_FILE));
        }
    }

    private static boolean linuxSendFileSupported() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.6")) {
            int idx = version.indexOf(95);
            if (idx == -1) {
                return false;
            }
            int patchRev = Integer.parseInt(version.substring(idx + 1));
            return patchRev >= 18;
        }
        return version.startsWith("1.7") || version.startsWith("1.8");
    }
}

