/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import org.glassfish.grizzly.Grizzly;

public class ServerFilterConfiguration {
    public static final String USE_SEND_FILE = "org.glassfish.grizzly.http.USE_SEND_FILE";
    private String httpServerName;
    private String httpServerVersion;
    private boolean sendFileEnabled;
    private String scheme;

    public ServerFilterConfiguration() {
        this("Grizzly", Grizzly.getDotedVersion());
    }

    public ServerFilterConfiguration(String serverName, String serverVersion) {
        this.httpServerName = serverName;
        this.httpServerVersion = serverVersion;
        this.configureSendFileSupport();
    }

    public ServerFilterConfiguration(ServerFilterConfiguration configuration) {
        this.httpServerName = configuration.httpServerName;
        this.httpServerVersion = configuration.httpServerVersion;
        this.sendFileEnabled = configuration.sendFileEnabled;
        this.scheme = configuration.scheme;
    }

    public String getHttpServerName() {
        return this.httpServerName;
    }

    public void setHttpServerName(String httpServerName) {
        this.httpServerName = httpServerName;
    }

    public String getHttpServerVersion() {
        return this.httpServerVersion;
    }

    public void setHttpServerVersion(String httpServerVersion) {
        this.httpServerVersion = httpServerVersion;
    }

    public boolean isSendFileEnabled() {
        return this.sendFileEnabled;
    }

    public void setSendFileEnabled(boolean sendFileEnabled) {
        this.sendFileEnabled = sendFileEnabled;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    private void configureSendFileSupport() {
        if (System.getProperty("os.name").equalsIgnoreCase("linux") && !ServerFilterConfiguration.linuxSendFileSupported() || System.getProperty("os.name").equalsIgnoreCase("HP-UX")) {
            this.sendFileEnabled = false;
        }
        if (System.getProperty(USE_SEND_FILE) != null) {
            this.sendFileEnabled = Boolean.valueOf(System.getProperty(USE_SEND_FILE));
        }
    }

    private static boolean linuxSendFileSupported(String jdkVersion) {
        if (jdkVersion.startsWith("1.6")) {
            char c;
            int idx = jdkVersion.indexOf(95);
            if (idx == -1) {
                return false;
            }
            StringBuilder sb = new StringBuilder(3);
            String substr = jdkVersion.substring(idx + 1);
            int len = Math.min(substr.length(), 3);
            for (int i = 0; i < len && Character.isDigit(c = substr.charAt(i)); ++i) {
                sb.append(c);
            }
            if (sb.length() == 0) {
                return false;
            }
            int patchRev = Integer.parseInt(sb.toString());
            return patchRev >= 18;
        }
        return jdkVersion.startsWith("1.7") || jdkVersion.startsWith("1.8");
    }

    private static boolean linuxSendFileSupported() {
        return ServerFilterConfiguration.linuxSendFileSupported(System.getProperty("java.version"));
    }
}

