/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.server.FileCacheFilter;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.filecache.FileCache;
import org.glassfish.grizzly.http.server.io.OutputBuffer;
import org.glassfish.grizzly.http.server.util.MimeType;
import org.glassfish.grizzly.http.util.HttpStatus;

public class StaticResourcesHandler {
    private static Logger logger = Grizzly.logger(StaticResourcesHandler.class);
    protected volatile File docRoot;
    protected String resourcesContextPath = "";
    private volatile int fileCacheFilterIdx = -1;

    public StaticResourcesHandler() {
        this(".");
    }

    public StaticResourcesHandler(String rootFolder) {
        this.setDocRoot(rootFolder);
    }

    public StaticResourcesHandler(File rootFolder) {
        this.setDocRoot(rootFolder);
    }

    public boolean handle(Request req, Response res) throws Exception {
        String uri = req.getRequestURI();
        if (uri.indexOf("..") >= 0 || !uri.startsWith(this.resourcesContextPath)) {
            return false;
        }
        if (uri.indexOf(".") != -1) {
            uri = uri.substring(this.resourcesContextPath.length());
        }
        return this.handle(uri, req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handle(String uri, Request req, Response res) throws Exception {
        int rd;
        String substr;
        FileInputStream fis = null;
        File resource = new File(this.docRoot, uri);
        if (resource.isDirectory()) {
            File f = new File(resource, "/index.html");
            resource = !f.exists() ? null : f;
        }
        if (resource == null || !resource.exists()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "File not found  " + resource);
            }
            boolean f = false;
            return f;
        }
        res.setStatus(HttpStatus.OK_200);
        int dot = uri.lastIndexOf(".");
        if (dot < 0) {
            substr = resource.toString();
            dot = substr.lastIndexOf(".");
        } else {
            substr = uri;
        }
        if (dot > 0) {
            String ext = substr.substring(dot + 1);
            String ct = MimeType.get(ext);
            if (ct != null) {
                res.setContentType(ct);
            }
        } else {
            res.setContentType(MimeType.get("html"));
        }
        long length = resource.length();
        res.setContentLengthLong(length);
        this.addToFileCache(req, resource);
        res.flush();
        fis = new FileInputStream(resource);
        OutputBuffer outputBuffer = res.getOutputBuffer();
        byte[] b = new byte[8192];
        while ((rd = fis.read(b)) > 0) {
            outputBuffer.write(b, 0, rd);
        }
        boolean bl = true;
        return bl;
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public File getDocRoot() {
        return this.docRoot;
    }

    public void setDocRoot(String docRoot) {
        if (docRoot != null) {
            this.setDocRoot(new File(docRoot));
        } else {
            this.setDocRoot((File)null);
        }
    }

    public void setDocRoot(File docRoot) {
        this.docRoot = docRoot;
    }

    public String getResourcesContextPath() {
        return this.resourcesContextPath;
    }

    public void setResourcesContextPath(String resourcesContextPath) {
        this.resourcesContextPath = resourcesContextPath;
    }

    public final boolean addToFileCache(Request req, File resource) {
        FilterChainContext fcContext = req.getContext();
        FileCacheFilter fileCacheFilter = this.lookupFileCache(fcContext);
        if (fileCacheFilter != null) {
            FileCache fileCache = fileCacheFilter.getFileCache();
            fileCache.add(req.getRequest(), resource);
            return true;
        }
        return false;
    }

    private FileCacheFilter lookupFileCache(FilterChainContext fcContext) {
        Filter filter;
        FilterChain fc = fcContext.getFilterChain();
        int lastFileCacheIdx = this.fileCacheFilterIdx;
        if (lastFileCacheIdx != -1 && (filter = (Filter)fc.get(lastFileCacheIdx)) instanceof FileCacheFilter) {
            return (FileCacheFilter)filter;
        }
        int size = fc.size();
        for (int i = 0; i < size; ++i) {
            Filter filter2 = (Filter)fc.get(i);
            if (!(filter2 instanceof FileCacheFilter)) continue;
            this.fileCacheFilterIdx = i;
            return (FileCacheFilter)filter2;
        }
        this.fileCacheFilterIdx = -1;
        return null;
    }
}

