/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.HttpServerMonitoringConfig;
import org.glassfish.grizzly.http.server.HttpService;
import org.glassfish.grizzly.http.server.HttpServiceChain;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.io.NIOOutputStream;
import org.glassfish.grizzly.http.server.jmx.JmxEventListener;
import org.glassfish.grizzly.http.server.util.HtmlHelper;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;

public class ServerConfiguration {
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger(-1);
    private String docRoot = null;
    private Map<HttpService, String[]> services = new LinkedHashMap<HttpService, String[]>();
    private Set<JmxEventListener> jmxEventListeners = new CopyOnWriteArraySet<JmxEventListener>();
    private static final String[] ROOT_MAPPING = new String[]{"/"};
    private final HttpServerMonitoringConfig monitoringConfig = new HttpServerMonitoringConfig();
    private String name;
    private String httpServerName = "Grizzly";
    private String httpServerVersion = "2.0";
    private final HttpServer instance;
    private boolean jmxEnabled;

    ServerConfiguration(HttpServer instance) {
        this.instance = instance;
    }

    public String getDocRoot() {
        return this.docRoot;
    }

    public void setDocRoot(String docRoot) {
        this.docRoot = docRoot;
    }

    public void addHttpService(HttpService httpService, String ... mapping) {
        if (mapping == null) {
            mapping = ROOT_MAPPING;
        }
        this.services.put(httpService, mapping);
    }

    public boolean removeHttpService(HttpService httpService) {
        return this.services.remove(httpService) != null;
    }

    protected HttpService buildService() {
        if (this.services.isEmpty()) {
            return new HttpService(this.docRoot){

                @Override
                public void service(Request request, Response response) {
                    try {
                        ByteBuffer b = HtmlHelper.getErrorPage("Not Found", "Resource identified by path '" + request.getRequestURI() + "', does not exist.", ServerConfiguration.this.getHttpServerName() + '/' + ServerConfiguration.this.getHttpServerVersion());
                        MemoryManager mm = request.getContext().getConnection().getTransport().getMemoryManager();
                        Buffer buf = Buffers.wrap((MemoryManager)mm, (ByteBuffer)b);
                        NIOOutputStream out = response.getOutputStream();
                        response.setStatus(HttpStatus.NOT_FOUND_404);
                        response.setContentType("text/html");
                        response.setCharacterEncoding("UTF-8");
                        out.write(buf);
                        out.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
        }
        int servicesNum = this.services.size();
        if (servicesNum == 1) {
            HttpService httpService = this.services.keySet().iterator().next();
            if (httpService.getDocRoot() == null) {
                httpService.setDocRoot(this.docRoot);
            }
            return httpService;
        }
        HttpServiceChain serviceChain = new HttpServiceChain(this.instance);
        this.addJmxEventListener(serviceChain);
        serviceChain.setDocRoot(this.docRoot);
        for (Map.Entry<HttpService, String[]> serviceRecord : this.services.entrySet()) {
            HttpService httpService = serviceRecord.getKey();
            String[] mappings = serviceRecord.getValue();
            if (httpService.getDocRoot() == null) {
                httpService.setDocRoot(this.docRoot);
            }
            serviceChain.addService(httpService, mappings);
        }
        return serviceChain;
    }

    public HttpServerMonitoringConfig getMonitoringConfig() {
        return this.monitoringConfig;
    }

    public String getName() {
        if (this.name == null) {
            if (!this.instance.isStarted()) {
                return null;
            }
            int count = INSTANCE_COUNT.incrementAndGet();
            this.name = count == 0 ? "HttpServer" : "HttpServer-" + count;
        }
        return this.name;
    }

    public void setName(String name) {
        if (!this.instance.isStarted()) {
            this.name = name;
        }
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    public void setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
        if (this.instance.isStarted()) {
            if (jmxEnabled) {
                this.instance.enableJMX();
                if (!this.jmxEventListeners.isEmpty()) {
                    for (JmxEventListener l : this.jmxEventListeners) {
                        l.jmxEnabled();
                    }
                }
            } else {
                if (!this.jmxEventListeners.isEmpty()) {
                    for (JmxEventListener l : this.jmxEventListeners) {
                        l.jmxDisabled();
                    }
                }
                this.instance.disableJMX();
            }
        }
    }

    public void addJmxEventListener(JmxEventListener listener) {
        if (listener != null) {
            this.jmxEventListeners.add(listener);
        }
    }

    public void removeJmxEventListener(JmxEventListener listener) {
        if (listener != null) {
            this.jmxEventListeners.remove(listener);
        }
    }

    public Iterator<JmxEventListener> getJmxEventListeners() {
        return this.jmxEventListeners.iterator();
    }

    public String getHttpServerName() {
        return this.httpServerName;
    }

    public void setHttpServerName(String httpServerName) {
        this.httpServerName = httpServerName;
    }

    public String getHttpServerVersion() {
        return this.httpServerVersion;
    }

    public void setHttpServerVersion(String httpServerVersion) {
        this.httpServerVersion = httpServerVersion;
    }
}

