/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.TransportFactory;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.HttpService;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.jmx.JmxEventListener;
import org.glassfish.grizzly.http.server.jmx.Monitorable;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.RequestURIRef;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;

public class HttpServiceChain
extends HttpService
implements JmxEventListener {
    private static final Logger logger = Grizzly.logger(HttpServiceChain.class);
    protected static final int MAPPING_DATA = 12;
    protected static final int MAPPED_SERVICE = 13;
    private ConcurrentHashMap<HttpService, String[]> services = new ConcurrentHashMap();
    private ConcurrentHashMap<HttpService, JmxObject> monitors = new ConcurrentHashMap();
    private Mapper mapper;
    private static final String LOCAL_HOST = "localhost";
    private boolean oldMappingAlgorithm = false;
    private boolean started;
    private final HttpServer gws;

    public HttpServiceChain(HttpServer gws) {
        this.gws = gws;
        this.mapper = new Mapper(TransportFactory.getInstance().getDefaultMemoryManager());
        this.mapper.setDefaultHostName(LOCAL_HOST);
        this.setDecodeUrl(false);
    }

    @Override
    public void jmxEnabled() {
        for (Map.Entry<HttpService, String[]> entry : this.services.entrySet()) {
            HttpService httpService = entry.getKey();
            if (!(httpService instanceof Monitorable)) continue;
            this.registerJmxForService(httpService);
        }
    }

    @Override
    public void jmxDisabled() {
        for (Map.Entry<HttpService, String[]> entry : this.services.entrySet()) {
            HttpService httpService = entry.getKey();
            if (!(httpService instanceof Monitorable)) continue;
            this.deregisterJmxForService(httpService);
        }
    }

    @Override
    public void start() {
        for (Map.Entry<HttpService, String[]> entry : this.services.entrySet()) {
            HttpService httpService = entry.getKey();
            httpService.start();
        }
        this.started = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void service(Request request, Response response) throws Exception {
        if (this.oldMappingAlgorithm) {
            int i = 0;
            int size = this.services.size();
            for (Map.Entry<HttpService, String[]> entry : this.services.entrySet()) {
                entry.getKey().doService(request, response);
                if (response.getStatus() != 404 || i == size - 1) {
                    return;
                }
                response.setStatus(HttpStatus.OK_200);
                ++i;
            }
            return;
        } else {
            try {
                RequestURIRef uriRef = request.getRequest().getRequestURIRef();
                BufferChunk decodedURI = uriRef.getDecodedRequestURIBC();
                MappingData mappingData = (MappingData)request.getNote("MAPPING_DATA");
                if (mappingData == null) {
                    mappingData = new MappingData();
                    request.setNote("MAPPING_DATA", mappingData);
                } else {
                    mappingData.recycle();
                }
                if (mappingData == null) {
                    mappingData = (MappingData)request.getNote("MAPPING_DATA");
                }
                this.mapUriWithSemicolon(request.getRequest().serverName(), decodedURI, 0, mappingData);
                if (mappingData.context != null && mappingData.context instanceof HttpService) {
                    HttpService httpService = mappingData.wrapper != null ? (HttpService)mappingData.wrapper : (HttpService)mappingData.context;
                    httpService.setDecodeUrl(false);
                    httpService.doService(request, response);
                    return;
                }
                response.setStatus(HttpStatus.NOT_FOUND_404);
                this.customizedErrorPage(this.gws, request, response);
                return;
            }
            catch (Throwable t) {
                try {
                    response.setStatus(HttpStatus.NOT_FOUND_404);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Invalid URL: " + request.getRequestURI(), t);
                    }
                    this.customizedErrorPage(this.gws, request, response);
                    return;
                }
                catch (Exception ex2) {
                    if (!logger.isLoggable(Level.WARNING)) return;
                    logger.log(Level.WARNING, "Unable to error page", ex2);
                }
            }
        }
    }

    public void addService(HttpService httpService, String[] mappings) {
        if (this.oldMappingAlgorithm) {
            throw new IllegalStateException("Cannot mix addService(HttpService) and addService(HttpService,String[]");
        }
        if (mappings.length == 0) {
            this.addService(httpService, new String[]{""});
        } else {
            if (this.started) {
                httpService.start();
                if (httpService instanceof Monitorable) {
                    this.registerJmxForService(httpService);
                }
            }
            this.services.put(httpService, mappings);
            for (String mapping : mappings) {
                String ctx = this.getContextPath(mapping);
                this.mapper.addContext(LOCAL_HOST, ctx, httpService, new String[]{"index.html", "index.htm"}, null);
                this.mapper.addWrapper(LOCAL_HOST, ctx, mapping.substring(ctx.length()), httpService);
            }
        }
    }

    private void registerJmxForService(HttpService httpService) {
        Monitorable monitorable = (Monitorable)((Object)httpService);
        JmxObject jmx = monitorable.createManagementObject();
        this.monitors.putIfAbsent(httpService, jmx);
        this.gws.jmxManager.register((Object)this.gws.managementObject, jmx, jmx.getJmxName());
    }

    private void deregisterJmxForService(HttpService httpService) {
        JmxObject jmx = this.monitors.get(httpService);
        if (jmx != null) {
            this.gws.jmxManager.unregister(jmx);
        }
    }

    private String getContextPath(String mapping) {
        int slash = mapping.indexOf("/", 1);
        String ctx = slash != -1 ? mapping.substring(0, slash) : mapping;
        if (ctx.startsWith("/*")) {
            ctx = "";
        }
        if (ctx.equals("/")) {
            ctx = "";
        }
        return ctx;
    }

    @Override
    public void destroy() {
        for (Map.Entry<HttpService, String[]> service : this.services.entrySet()) {
            HttpService a = service.getKey();
            a.destroy();
        }
        this.started = false;
    }

    public boolean removeHttpService(HttpService httpService) {
        if (httpService == null) {
            throw new IllegalStateException();
        }
        String[] mappings = this.services.remove(httpService);
        if (mappings != null) {
            for (String mapping : mappings) {
                String ctx = this.getContextPath(mapping);
                this.mapper.removeContext(LOCAL_HOST, ctx);
            }
            this.deregisterJmxForService(httpService);
            httpService.destroy();
        }
        return mappings != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapUriWithSemicolon(BufferChunk serverName, BufferChunk decodedURI, int semicolonPos, MappingData mappingData) throws Exception {
        int oldEnd = decodedURI.getEnd();
        if (semicolonPos == 0) {
            semicolonPos = decodedURI.indexOf(';', 0);
        }
        if (semicolonPos == -1) {
            semicolonPos = oldEnd;
        }
        decodedURI.setEnd(semicolonPos);
        try {
            this.mapper.map(serverName, decodedURI, mappingData);
        }
        finally {
            decodedURI.setEnd(oldEnd);
        }
    }
}

