/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.http.server.StaticResourcesHandler;
import org.glassfish.grizzly.http.server.io.OutputBuffer;
import org.glassfish.grizzly.http.server.util.HtmlHelper;
import org.glassfish.grizzly.http.util.HttpStatus;

public abstract class HttpService {
    private static final Logger logger = Grizzly.logger(HttpService.class);
    protected final StaticResourcesHandler staticResourcesHandler = new StaticResourcesHandler();
    private boolean allowEncodedSlash = false;
    private boolean decodeURL = true;

    public HttpService() {
        this(null);
    }

    public HttpService(String docRoot) {
        this.staticResourcesHandler.setDocRoot(docRoot);
    }

    public final void doService(Request request, Response response) throws Exception {
        if (request.requiresAcknowledgement() && !this.sendAcknowledgment(request, response)) {
            return;
        }
        if (this.staticResourcesHandler.getDocRoot() != null && this.staticResourcesHandler.handle(request, response)) {
            return;
        }
        try {
            if (this.decodeURL) {
                HttpRequestPacket httpRequestPacket = request.getRequest();
                try {
                    httpRequestPacket.getRequestURIRef().getDecodedRequestURIBC(this.allowEncodedSlash);
                }
                catch (CharConversionException e) {
                    response.setStatus(HttpStatus.NOT_FOUND_404);
                    response.setDetailMessage("Invalid URI: " + e.getMessage());
                    return;
                }
            }
            request.parseSessionId();
            this.service(request, response);
        }
        catch (Exception t) {
            logger.log(Level.SEVERE, "service exception", t);
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR_500);
            response.setDetailMessage("Internal Error");
            throw t;
        }
    }

    public abstract void service(Request var1, Response var2) throws Exception;

    public void start() {
    }

    public void destroy() {
    }

    public StaticResourcesHandler getStaticResourcesHandler() {
        return this.staticResourcesHandler;
    }

    public boolean isAllowEncodedSlash() {
        return this.allowEncodedSlash;
    }

    public void setAllowEncodedSlash(boolean allowEncodedSlash) {
        this.allowEncodedSlash = allowEncodedSlash;
    }

    public File getDocRoot() {
        return this.staticResourcesHandler.getDocRoot();
    }

    public void setDocRoot(String docRoot) {
        this.staticResourcesHandler.setDocRoot(docRoot);
    }

    public void setDocRoot(File docRoot) {
        this.staticResourcesHandler.setDocRoot(docRoot);
    }

    protected void customizedErrorPage(HttpServer server, Request req, Response res) throws Exception {
        res.setStatus(HttpStatus.NOT_FOUND_404);
        ServerConfiguration c = server.getServerConfiguration();
        String serverName = c.getHttpServerName() + '/' + c.getHttpServerVersion();
        ByteBuffer bb = HtmlHelper.getErrorPage("Not Found", "Resource identified by path '" + req.getRequestURI() + "', does not exist.", serverName);
        res.setContentLength(bb.limit());
        res.setContentType("text/html");
        OutputBuffer out = res.getOutputBuffer();
        out.processingChars();
        out.write(bb.array(), bb.position(), bb.remaining());
        out.close();
    }

    protected boolean sendAcknowledgment(Request request, Response response) throws IOException {
        if ("100-Continue".equals(request.getHeader("Expect"))) {
            response.setStatus(HttpStatus.CONINTUE_100);
            response.sendAcknowledgement();
            return true;
        }
        response.setStatus(HttpStatus.EXPECTATION_FAILED_417);
        return false;
    }

    protected void setDecodeUrl(boolean decodeURL) {
        this.decodeURL = decodeURL;
    }
}

