/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.server.FileCacheFilter;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.filecache.FileCache;
import org.glassfish.grizzly.http.server.io.OutputBuffer;
import org.glassfish.grizzly.http.server.util.MimeType;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.utils.ArraySet;

public class StaticHttpHandler
extends HttpHandler {
    private static final Logger LOGGER = Grizzly.logger(StaticHttpHandler.class);
    protected final ArraySet<File> docRoots = new ArraySet(File.class);
    private volatile int fileCacheFilterIdx = -1;

    public StaticHttpHandler() {
        this.addDocRoot(".");
    }

    public StaticHttpHandler(String ... docRoots) {
        if (docRoots != null) {
            for (String docRoot : docRoots) {
                this.addDocRoot(docRoot);
            }
        }
    }

    public StaticHttpHandler(Set<String> docRoots) {
        if (docRoots != null) {
            for (String docRoot : docRoots) {
                this.addDocRoot(docRoot);
            }
        }
    }

    public File getDefaultDocRoot() {
        File[] array = (File[])this.docRoots.getArray();
        return array != null && array.length > 0 ? array[0] : null;
    }

    public ArraySet<File> getDocRoots() {
        return this.docRoots;
    }

    public final File addDocRoot(String docRoot) {
        if (docRoot == null) {
            throw new NullPointerException("docRoot can't be null");
        }
        File file = new File(docRoot);
        this.addDocRoot(file);
        return file;
    }

    public final void addDocRoot(File docRoot) {
        this.docRoots.add((Object)docRoot);
    }

    public void removeDocRoot(File docRoot) {
        this.docRoots.remove((Object)docRoot);
    }

    @Override
    public void service(Request request, Response response) throws Exception {
        String uri = this.getRelativeURI(request);
        if (uri == null || !this.handle(uri, request, response)) {
            this.onMissingResource(request, response);
        }
    }

    protected String getRelativeURI(Request request) {
        String uri = request.getRequestURI();
        if (uri.indexOf("..") >= 0) {
            return null;
        }
        String resourcesContextPath = request.getContextPath();
        if (!"".equals(resourcesContextPath)) {
            if (!uri.startsWith(resourcesContextPath)) {
                return null;
            }
            uri = uri.substring(resourcesContextPath.length());
        }
        return uri;
    }

    protected void onMissingResource(Request request, Response response) throws Exception {
        response.setStatus(HttpStatus.NOT_FOUND_404);
        this.customizedErrorPage(request, response);
    }

    protected boolean handle(String uri, Request req, Response res) throws Exception {
        boolean found = false;
        File[] fileFolders = (File[])this.docRoots.getArray();
        if (fileFolders == null) {
            return false;
        }
        File resource = null;
        for (int i = 0; i < fileFolders.length; ++i) {
            File f;
            File webDir = fileFolders[i];
            resource = new File(webDir, uri);
            boolean exists = resource.exists();
            boolean isDirectory = resource.isDirectory();
            if (exists && isDirectory && (f = new File(resource, "/index.html")).exists()) {
                resource = f;
                found = true;
                break;
            }
            if (!isDirectory && exists) {
                found = true;
                break;
            }
            found = false;
        }
        if (!found) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "File not found  {0}", resource);
            }
            return false;
        }
        this.addToFileCache(req, resource);
        StaticHttpHandler.sendFile(res, resource);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendFile(Response response, File file) throws IOException {
        String path = file.getPath();
        FileInputStream fis = new FileInputStream(file);
        try {
            int rd;
            String substr;
            response.setStatus(HttpStatus.OK_200);
            int dot = path.lastIndexOf(".");
            if (dot < 0) {
                substr = file.toString();
                dot = substr.lastIndexOf(".");
            } else {
                substr = path;
            }
            if (dot > 0) {
                String ext = substr.substring(dot + 1);
                String ct = MimeType.get(ext);
                if (ct != null) {
                    response.setContentType(ct);
                }
            } else {
                response.setContentType(MimeType.get("html"));
            }
            long length = file.length();
            response.setContentLengthLong(length);
            OutputBuffer outputBuffer = response.getOutputBuffer();
            byte[] b = new byte[8192];
            while ((rd = fis.read(b)) > 0) {
                outputBuffer.write(b, 0, rd);
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ignore) {}
        }
    }

    public final boolean addToFileCache(Request req, File resource) {
        FilterChainContext fcContext = req.getContext();
        FileCacheFilter fileCacheFilter = this.lookupFileCache(fcContext);
        if (fileCacheFilter != null) {
            FileCache fileCache = fileCacheFilter.getFileCache();
            fileCache.add(req.getRequest(), resource);
            return true;
        }
        return false;
    }

    private FileCacheFilter lookupFileCache(FilterChainContext fcContext) {
        Filter filter;
        FilterChain fc = fcContext.getFilterChain();
        int lastFileCacheIdx = this.fileCacheFilterIdx;
        if (lastFileCacheIdx != -1 && (filter = (Filter)fc.get(lastFileCacheIdx)) instanceof FileCacheFilter) {
            return (FileCacheFilter)filter;
        }
        int size = fc.size();
        for (int i = 0; i < size; ++i) {
            Filter filter2 = (Filter)fc.get(i);
            if (!(filter2 instanceof FileCacheFilter)) continue;
            this.fileCacheFilterIdx = i;
            return (FileCacheFilter)filter2;
        }
        this.fileCacheFilterIdx = -1;
        return null;
    }
}

