/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.DefaultAttributeBuilder;
import org.glassfish.grizzly.attributes.IndexedAttributeHolder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.Cookies;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.server.AfterServiceListener;
import org.glassfish.grizzly.http.server.HttpServerFilter;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.Session;
import org.glassfish.grizzly.http.server.io.InputBuffer;
import org.glassfish.grizzly.http.server.io.NIOInputStream;
import org.glassfish.grizzly.http.server.io.NIOReader;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.server.util.ParameterMap;
import org.glassfish.grizzly.http.server.util.StringParser;
import org.glassfish.grizzly.http.util.Charsets;
import org.glassfish.grizzly.http.util.Chunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.FastHttpDateFormat;
import org.glassfish.grizzly.http.util.Parameters;
import org.glassfish.grizzly.http.util.RequestURIRef;
import org.glassfish.grizzly.http.util.StringManager;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.ssl.SSLSupportImpl;

public class Request {
    private static final Logger LOGGER = Grizzly.logger(Request.class);
    private static final ThreadCache.CachedTypeIndex<Request> CACHE_IDX = ThreadCache.obtainIndex(Request.class, (int)2);
    private static final ThreadLocal<Connection> connection = new ThreadLocal();
    private static final AttributeBuilder ATTR_BUILDER = new DefaultAttributeBuilder();
    private static final String match = ";jsessionid=";
    private static final char[] SESSION_ID = ";jsessionid=".toCharArray();
    private static Map<String, Session> sessions = new HashMap<String, Session>();
    private static final ScheduledThreadPoolExecutor sessionExpirer = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new SchedulerThread(r, "Grizzly");
        }
    });
    protected HttpRequestPacket request;
    protected FilterChainContext ctx;
    protected HttpServerFilter httpServerFilter;
    protected final List<AfterServiceListener> afterServicesList = new ArrayList<AfterServiceListener>();
    private Session session;
    private String contextPath = "";
    private MappingData cachedMappingData;
    protected static final StringManager sm;
    protected Cookie[] cookies = null;
    protected Cookies rawCookies;
    protected static final Locale defaultLocale;
    protected final HashMap<String, Object> attributes = new HashMap();
    private final HashMap<String, Object> readOnlyAttributes = new HashMap();
    protected final ArrayList<Locale> locales = new ArrayList();
    private final transient AttributeHolder notesHolder = new IndexedAttributeHolder(ATTR_BUILDER);
    protected String authType = null;
    protected Object dispatcherType = null;
    protected InputBuffer inputBuffer = new InputBuffer();
    protected NIOInputStream inputStream;
    protected NIOReader reader;
    protected boolean usingInputStream = false;
    protected boolean usingReader = false;
    protected Principal userPrincipal = null;
    protected boolean sessionParsed = false;
    protected boolean requestParametersParsed = false;
    protected boolean cookiesParsed = false;
    protected boolean secure = false;
    protected Subject subject = null;
    protected static final int CACHED_POST_LEN = 8192;
    protected byte[] postData = null;
    protected final ParameterMap parameterMap = new ParameterMap();
    protected final Parameters parameters = new Parameters();
    protected Object requestDispatcherPath = null;
    protected boolean requestedSessionCookie = false;
    protected String requestedSessionId = null;
    protected boolean requestedSessionURL = false;
    protected boolean localesParsed = false;
    private StringParser parser = new StringParser();
    private int dispatchDepth = 0;
    private static int maxDispatchDepth;
    private String jrouteId;
    protected Response response = null;

    public static Request create() {
        Request request = (Request)ThreadCache.takeFromCache(CACHE_IDX);
        if (request != null) {
            return request;
        }
        return new Request();
    }

    final MappingData obtainMappingData() {
        if (this.cachedMappingData == null) {
            this.cachedMappingData = new MappingData();
        }
        return this.cachedMappingData;
    }

    public static Connection getConnection() {
        return connection.get();
    }

    public static void setConnection(Connection conn) {
        connection.set(conn);
    }

    protected Request() {
    }

    public void initialize(Response response, HttpRequestPacket request, FilterChainContext ctx, HttpServerFilter httpServerFilter) {
        this.response = response;
        this.request = request;
        this.ctx = ctx;
        this.httpServerFilter = httpServerFilter;
        this.inputBuffer.initialize(request, ctx);
        this.parameters.setHeaders(request.getHeaders());
        this.parameters.setQuery(request.getQueryStringDC());
    }

    final HttpServerFilter getServerFilter() {
        return this.httpServerFilter;
    }

    public HttpRequestPacket getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public void addAfterServiceListener(AfterServiceListener listener) {
        this.afterServicesList.add(listener);
    }

    public void removeAfterServiceListener(AfterServiceListener listener) {
        this.afterServicesList.remove(listener);
    }

    protected void onAfterService() {
        for (AfterServiceListener anAfterServicesList : this.afterServicesList) {
            try {
                anAfterServicesList.onAfterService(this);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Unexpected error during afterService notification", e);
            }
        }
    }

    protected final void recycle() {
        this.contextPath = "";
        connection.set(null);
        this.dispatcherType = null;
        this.requestDispatcherPath = null;
        this.authType = null;
        this.inputBuffer.recycle();
        this.usingInputStream = false;
        this.usingReader = false;
        this.userPrincipal = null;
        this.subject = null;
        this.sessionParsed = false;
        this.requestParametersParsed = false;
        this.cookiesParsed = false;
        if (this.rawCookies != null) {
            this.rawCookies.recycle();
        }
        this.locales.clear();
        this.localesParsed = false;
        this.secure = false;
        this.inputStream = null;
        this.reader = null;
        this.request.recycle();
        if (this.rawCookies != null) {
            this.rawCookies.recycle();
        }
        this.response = null;
        this.request = null;
        this.ctx = null;
        this.httpServerFilter = null;
        this.attributes.clear();
        this.cookies = null;
        this.requestedSessionId = null;
        this.session = null;
        this.dispatchDepth = 0;
        this.parameterMap.setLocked(false);
        this.parameterMap.clear();
        this.parameters.recycle();
        this.afterServicesList.clear();
        if (this.cachedMappingData != null) {
            this.cachedMappingData.recycle();
        }
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    public String getAuthorization() {
        return this.request.getHeader("authorization");
    }

    private InputStream getStream() {
        if (this.inputStream == null) {
            this.inputStream = new NIOInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public NIOInputStream createInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new NIOInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public static <E> Note<E> createNote(String name) {
        return new Note(ATTR_BUILDER.createAttribute(name));
    }

    public <E> E getNote(Note<E> note) {
        return (E)((Note)note).attribute.get(this.notesHolder);
    }

    public Set<String> getNoteNames() {
        return this.notesHolder.getAttributeNames();
    }

    public <E> E removeNote(Note<E> note) {
        return (E)((Note)note).attribute.remove(this.notesHolder);
    }

    public <E> void setNote(Note<E> note, E value) {
        ((Note)note).attribute.set(this.notesHolder, value);
    }

    public void setServerName(String name) {
        this.request.serverName().setString(name);
    }

    public void setServerPort(int port) {
        this.request.setServerPort(port);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    protected void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    static boolean isSSLAttribute(String name) {
        return "javax.servlet.request.X509Certificate".equals(name) || "javax.servlet.request.cipher_suite".equals(name) || "javax.servlet.request.key_size".equals(name);
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public int getContentLength() {
        return (int)this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public NIOInputStream getInputStream(boolean blocking) throws IOException {
        if (this.usingReader) {
            throw new IllegalStateException(sm.getString("request.getInputStream.ise"));
        }
        this.usingInputStream = true;
        if (this.inputStream == null) {
            this.inputBuffer.setAsyncEnabled(!blocking);
            this.inputStream = new NIOInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public boolean asyncInput() {
        return this.inputBuffer.isAsyncEnabled();
    }

    public boolean requiresAcknowledgement() {
        return this.request.requiresAcknowledgement();
    }

    public Locale getLocale() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (this.locales.size() > 0) {
            return this.locales.get(0);
        }
        return defaultLocale;
    }

    public List<Locale> getLocales() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (!this.locales.isEmpty()) {
            return this.locales;
        }
        ArrayList<Locale> results = new ArrayList<Locale>();
        results.add(defaultLocale);
        return results;
    }

    public String getParameter(String name) {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.parameters.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.parameterMap.isLocked()) {
            return this.parameterMap;
        }
        for (String name : this.getParameterNames()) {
            String[] values = this.getParameterValues(name);
            this.parameterMap.put(name, values);
        }
        this.parameterMap.setLocked(true);
        return this.parameterMap;
    }

    public Set<String> getParameterNames() {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.parameters.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.parameters.getParameterValues(name);
    }

    public Protocol getProtocol() {
        return this.request.getProtocol();
    }

    public NIOReader getReader(boolean blocking) throws IOException {
        if (this.usingInputStream) {
            throw new IllegalStateException(sm.getString("request.getReader.ise"));
        }
        this.usingReader = true;
        if (this.reader == null) {
            this.inputBuffer.processingChars();
            this.inputBuffer.setAsyncEnabled(!blocking);
            this.reader = new NIOReader(this.inputBuffer);
        }
        return this.reader;
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddress();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public int getRemotePort() {
        return this.request.getRemotePort();
    }

    public String getLocalName() {
        return this.request.getLocalName();
    }

    public String getLocalAddr() {
        return this.request.getLocalAddress();
    }

    public int getLocalPort() {
        return this.request.getLocalPort();
    }

    public String getScheme() {
        return this.request.isSecure() ? "https" : "http";
    }

    public String getServerName() {
        return this.request.serverName().toString();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public void removeAttribute(String name) {
        if (this.readOnlyAttributes.containsKey(name)) {
            return;
        }
        boolean found = this.attributes.containsKey(name);
        if (found) {
            this.attributes.remove(name);
        }
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("request.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            this.dispatcherType = value;
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            this.requestDispatcherPath = value;
            return;
        }
        if (this.readOnlyAttributes.containsKey(name)) {
            return;
        }
        this.attributes.put(name, value);
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this.requestParametersParsed || this.usingReader) {
            return;
        }
        Charsets.lookupCharset((String)encoding);
        this.request.setCharacterEncoding(encoding);
    }

    public static void setMaxDispatchDepth(int depth) {
        maxDispatchDepth = depth;
    }

    public static int getMaxDispatchDepth() {
        return maxDispatchDepth;
    }

    public int incrementDispatchDepth() {
        return ++this.dispatchDepth;
    }

    public int decrementDispatchDepth() {
        return --this.dispatchDepth;
    }

    public boolean isMaxDispatchDepthReached() {
        return this.dispatchDepth > maxDispatchDepth;
    }

    public void addCookie(Cookie cookie) {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        int size = 0;
        if (cookie != null) {
            size = this.cookies.length;
        }
        Cookie[] newCookies = new Cookie[size + 1];
        System.arraycopy(this.cookies, 0, newCookies, 0, size);
        newCookies[size] = cookie;
        this.cookies = newCookies;
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    public void addParameter(String name, String[] values) {
        this.parameters.addParameterValues(name, values);
    }

    public void clearCookies() {
        this.cookiesParsed = true;
        this.cookies = null;
    }

    public void clearHeaders() {
    }

    public void clearLocales() {
        this.locales.clear();
    }

    public void clearParameters() {
    }

    public void setAuthType(String type) {
        this.authType = type;
    }

    public String getDecodedRequestURI() throws CharConversionException {
        return this.request.getRequestURIRef().getDecodedURI();
    }

    public void setUserPrincipal(Principal principal) {
        this.userPrincipal = principal;
    }

    public String getAuthType() {
        return this.authType;
    }

    public Cookie[] getCookies() {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        return this.cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        SimpleDateFormats formats = SimpleDateFormats.create();
        try {
            long result = FastHttpDateFormat.parseDate((String)value, (DateFormat[])formats.getFormats());
            if (result != -1L) {
                long l = result;
                return l;
            }
            throw new IllegalArgumentException(value);
        }
        finally {
            formats.recycle();
        }
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Iterable<String> getHeaders(String name) {
        return this.request.getHeaders().values(name);
    }

    public Iterable<String> getHeaderNames() {
        return this.request.getHeaders().names();
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public Method getMethod() {
        return this.request.getMethod();
    }

    public void setMethod(String method) {
        this.request.setMethod(method);
    }

    public String getQueryString() {
        String queryString = this.request.getQueryString();
        if (queryString == null || queryString.isEmpty()) {
            return null;
        }
        return queryString;
    }

    public void setQueryString(String queryString) {
        this.request.setQueryString(queryString);
    }

    public String getRemoteUser() {
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return null;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public void setRequestURI(String uri) {
        this.request.setRequestURI(uri);
    }

    public StringBuilder getRequestURL() {
        StringBuilder url = new StringBuilder();
        return Request.appendRequestURL(this, url);
    }

    public static StringBuilder appendRequestURL(Request request, StringBuilder buffer) {
        String scheme = request.getScheme();
        int port = request.getServerPort();
        if (port < 0) {
            port = 80;
        }
        buffer.append(scheme);
        buffer.append("://");
        buffer.append(request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            buffer.append(':');
            buffer.append(port);
        }
        buffer.append(request.getRequestURI());
        return buffer;
    }

    public static StringBuffer appendRequestURL(Request request, StringBuffer buffer) {
        String scheme = request.getScheme();
        int port = request.getServerPort();
        if (port < 0) {
            port = 80;
        }
        buffer.append(scheme);
        buffer.append("://");
        buffer.append(request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            buffer.append(':');
            buffer.append(port);
        }
        buffer.append(request.getRequestURI());
        return buffer;
    }

    public Principal getUserPrincipal() {
        if (this.userPrincipal == null && this.getRequest().isSecure()) {
            SSLFilter.CertificateEvent event;
            block4: {
                event = new SSLFilter.CertificateEvent(true);
                try {
                    this.ctx.notifyDownstream((FilterChainEvent)event);
                }
                catch (IOException ioe) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block4;
                    LOGGER.log(Level.FINE, ioe.toString(), ioe);
                }
            }
            X509Certificate[] certs = (X509Certificate[])event.getCertificates();
            if (certs == null || certs.length < 1) {
                certs = (X509Certificate[])this.getAttribute("org.apache.coyote.request.X509Certificate");
            }
            this.userPrincipal = certs == null || certs.length < 1 ? null : certs[0].getSubjectX500Principal();
        }
        return this.userPrincipal;
    }

    public FilterChainContext getContext() {
        return this.ctx;
    }

    public void populateCertificateAttribute() {
        if (this.getRequest().isSecure()) {
            SSLFilter.CertificateEvent event;
            block3: {
                event = new SSLFilter.CertificateEvent(true);
                try {
                    this.ctx.notifyDownstream((FilterChainEvent)event);
                }
                catch (IOException ioe) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block3;
                    LOGGER.log(Level.FINE, ioe.toString(), ioe);
                }
            }
            this.attributes.put("javax.servlet.request.X509Certificate", event.getCertificates());
        }
    }

    public void populateSSLAttributes() {
        block6: {
            try {
                SSLSupportImpl sslSupport = new SSLSupportImpl(this.ctx.getConnection());
                Object sslO = sslSupport.getCipherSuite();
                if (sslO != null) {
                    this.attributes.put("javax.servlet.request.cipher_suite", sslO);
                }
                if ((sslO = sslSupport.getPeerCertificateChain(false)) != null) {
                    this.attributes.put("javax.servlet.request.X509Certificate", sslO);
                }
                if ((sslO = sslSupport.getKeySize()) != null) {
                    this.attributes.put("javax.servlet.request.key_size", sslO);
                }
                if ((sslO = sslSupport.getSessionId()) != null) {
                    this.attributes.put("javax.servlet.request.ssl_session", sslO);
                }
            }
            catch (IOException ioe) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block6;
                LOGGER.log(Level.WARNING, "Unable to populate SSL attributes", ioe);
            }
        }
    }

    protected String unescape(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(92) == -1) {
            return s;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\\') {
                buf.append(c);
                continue;
            }
            if (++i >= s.length()) {
                throw new IllegalArgumentException();
            }
            c = s.charAt(i);
            buf.append(c);
        }
        return buf.toString();
    }

    protected void parseCookies() {
        this.cookiesParsed = true;
        Cookies serverCookies = this.getRawCookies();
        Collection parsedCookies = serverCookies.get();
        this.cookies = parsedCookies.toArray(new Cookie[parsedCookies.size()]);
    }

    protected InputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    protected Cookies getRawCookies() {
        if (this.rawCookies == null) {
            this.rawCookies = new Cookies();
        }
        if (!this.rawCookies.initialized()) {
            this.rawCookies.setHeaders(this.request.getHeaders());
        }
        return this.rawCookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRequestParameters() {
        Charset charset;
        String enc = this.getCharacterEncoding();
        this.requestParametersParsed = true;
        if (enc != null) {
            try {
                charset = Charsets.lookupCharset((String)enc);
            }
            catch (Exception e) {
                charset = Charsets.DEFAULT_CHARSET;
            }
        } else {
            charset = Charsets.DEFAULT_CHARSET;
        }
        this.parameters.setEncoding(charset);
        this.parameters.setQueryStringEncoding(charset);
        this.parameters.handleQueryParameters();
        if (this.usingInputStream || this.usingReader) {
            return;
        }
        if (!Method.POST.equals(this.getMethod())) {
            return;
        }
        int len = this.getContentLength();
        if (len > 0) {
            if (!this.checkPostContentType(this.getContentType())) {
                return;
            }
            try {
                Buffer formData = this.getPostBody(len);
                this.parameters.processParameters(formData, 0, len);
            }
            catch (Exception ignored) {
            }
            finally {
                try {
                    this.skipPostBody(len);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Exception occurred during body skip", e);
                }
            }
        }
    }

    private boolean checkPostContentType(String contentType) {
        return contentType != null && contentType.trim().startsWith("application/x-www-form-urlencoded");
    }

    protected Buffer getPostBody(int len) throws IOException {
        this.inputBuffer.fillFully(len);
        return this.inputBuffer.getBuffer();
    }

    protected void skipPostBody(int len) throws IOException {
        this.inputBuffer.skip(len, false);
    }

    protected void parseLocales() {
        this.localesParsed = true;
        Iterable<String> values = this.getHeaders("accept-language");
        for (String value : values) {
            this.parseLocalesHeader(value);
        }
    }

    protected void parseLocalesHeader(String value) {
        int start;
        TreeMap<Double, ArrayList<Locale>> localLocales = new TreeMap<Double, ArrayList<Locale>>();
        int white = value.indexOf(32);
        if (white < 0) {
            white = value.indexOf(9);
        }
        if (white >= 0) {
            StringBuilder sb = new StringBuilder();
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                char ch = value.charAt(i);
                if (ch == ' ' || ch == '\t') continue;
                sb.append(ch);
            }
            value = sb.toString();
        }
        this.parser.setString(value);
        int length = this.parser.getLength();
        while ((start = this.parser.getIndex()) < length) {
            String variant;
            String country;
            String language;
            int end = this.parser.findChar(',');
            String entry = this.parser.extract(start, end).trim();
            this.parser.advance();
            double quality = 1.0;
            int semi = entry.indexOf(";q=");
            if (semi >= 0) {
                String qvalue = entry.substring(semi + 3);
                if (qvalue.length() <= 5) {
                    try {
                        quality = Double.parseDouble(qvalue);
                    }
                    catch (NumberFormatException e) {
                        quality = 0.0;
                    }
                } else {
                    quality = 0.0;
                }
                entry = entry.substring(0, semi);
            }
            if (quality < 5.0E-5 || "*".equals(entry)) continue;
            int dash = entry.indexOf(45);
            if (dash < 0) {
                language = entry;
                country = "";
                variant = "";
            } else {
                language = entry.substring(0, dash);
                country = entry.substring(dash + 1);
                int vDash = country.indexOf(45);
                if (vDash > 0) {
                    String cTemp = country.substring(0, vDash);
                    variant = country.substring(vDash + 1);
                    country = cTemp;
                } else {
                    variant = "";
                }
            }
            if (!Request.isAlpha(language) || !Request.isAlpha(country) || !Request.isAlpha(variant)) continue;
            Locale locale = new Locale(language, country, variant);
            Double key = -quality;
            ArrayList<Locale> values = (ArrayList<Locale>)localLocales.get(key);
            if (values == null) {
                values = new ArrayList<Locale>();
                localLocales.put(key, values);
            }
            values.add(locale);
        }
        Iterator i$ = localLocales.keySet().iterator();
        while (i$.hasNext()) {
            Double o;
            Double key = o = (Double)i$.next();
            ArrayList list = (ArrayList)localLocales.get(key);
            for (Object aList : list) {
                Locale locale = (Locale)aList;
                this.addLocale(locale);
            }
        }
    }

    void parseJrouteCookie() {
        Cookie cookie;
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        if ((cookie = this.getRawCookies().findByName("JROUTE")) != null) {
            this.setJrouteId(cookie.getValue());
        }
    }

    static boolean isAlpha(String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    void setJrouteId(String jrouteId) {
        this.jrouteId = jrouteId;
    }

    public String getJrouteId() {
        return this.jrouteId;
    }

    public Session getSession() {
        return this.doGetSession(true);
    }

    public Session getSession(boolean create) {
        return this.doGetSession(create);
    }

    protected Session doGetSession(boolean create) {
        if (this.session != null && !this.session.isValid()) {
            this.session = null;
        }
        if (this.session != null) {
            return this.session;
        }
        if (this.requestedSessionId != null) {
            this.session = sessions.get(this.requestedSessionId);
            if (this.session != null && !this.session.isValid()) {
                this.session = null;
            }
            if (this.session != null) {
                return this.session;
            }
        }
        if (!create) {
            return null;
        }
        if (this.requestedSessionId != null) {
            this.session = new Session(this.requestedSessionId);
        } else {
            Random r = new Random();
            this.requestedSessionId = String.valueOf(Math.abs(r.nextLong()));
            this.session = new Session(this.requestedSessionId);
        }
        sessions.put(this.requestedSessionId, this.session);
        if (this.session != null) {
            Cookie cookie = new Cookie("JSESSIONID", this.session.getIdInternal());
            this.configureSessionCookie(cookie);
            this.response.addCookie(cookie);
        }
        if (this.session != null) {
            return this.session;
        }
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionId != null && this.requestedSessionCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.requestedSessionId != null && this.requestedSessionURL;
    }

    public boolean isRequestedSessionIdValid() {
        if (this.requestedSessionId == null) {
            return false;
        }
        if (this.session != null && this.requestedSessionId.equals(this.session.getIdInternal())) {
            return this.session.isValid();
        }
        Session localSession = sessions.put(this.requestedSessionId, this.session);
        return localSession != null && localSession.isValid();
    }

    protected void configureSessionCookie(Cookie cookie) {
        cookie.setMaxAge(-1);
        cookie.setPath("/");
        if (this.isSecure()) {
            cookie.setSecure(true);
        }
    }

    protected void parseSessionId() {
        RequestURIRef ref = this.request.getRequestURIRef();
        DataChunk uriDC = ref.getRequestURIBC();
        switch (uriDC.getType()) {
            case Buffer: {
                this.parseSessionId((Chunk)uriDC.getBufferChunk());
                return;
            }
            case Chars: {
                this.parseSessionId((Chunk)uriDC.getCharChunk());
                return;
            }
        }
        throw new IllegalStateException("Unexpected DataChunk type: " + uriDC.getType());
    }

    private void parseSessionId(Chunk uriChunk) {
        int semicolon = uriChunk.indexOf(match, 0);
        if (semicolon > 0) {
            int sessionIdStart;
            int start = uriChunk.getStart();
            int semicolon2 = uriChunk.indexOf(';', sessionIdStart = start + semicolon + match.length());
            int end = semicolon2 >= 0 ? semicolon2 : uriChunk.getEnd();
            String sessionId = uriChunk.toString(sessionIdStart, end);
            int jrouteIndex = sessionId.lastIndexOf(58);
            if (jrouteIndex > 0) {
                this.setRequestedSessionId(sessionId.substring(0, jrouteIndex));
                if (jrouteIndex < sessionId.length() - 1) {
                    this.setJrouteId(sessionId.substring(jrouteIndex + 1));
                }
            } else {
                this.setRequestedSessionId(sessionId);
            }
            this.setRequestedSessionURL(true);
            uriChunk.delete(semicolon, end);
        } else {
            this.setRequestedSessionId(null);
            this.setRequestedSessionURL(false);
        }
    }

    public void setRequestedSessionCookie(boolean flag) {
        this.requestedSessionCookie = flag;
    }

    public void setRequestedSessionId(String id) {
        this.requestedSessionId = id;
    }

    public void setRequestedSessionURL(boolean flag) {
        this.requestedSessionURL = flag;
    }

    static {
        sessionExpirer.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long currentTime = System.currentTimeMillis();
                Iterator iterator = sessions.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (((Session)entry.getValue()).getSessionTimeout() == -1L || currentTime - ((Session)entry.getValue()).getTimestamp() <= ((Session)entry.getValue()).getSessionTimeout()) continue;
                    ((Session)entry.getValue()).setValid(false);
                    iterator.remove();
                }
            }
        }, 5L, 5L, TimeUnit.SECONDS);
        sm = StringManager.getManager((String)"org.glassfish.grizzly.http.server.res", (ClassLoader)Request.class.getClassLoader());
        defaultLocale = Locale.getDefault();
        maxDispatchDepth = 20;
    }

    public static final class Note<E> {
        private final Attribute<E> attribute;

        public Note(Attribute<E> attribute) {
            this.attribute = attribute;
        }
    }

    private static final class SimpleDateFormats {
        private static final ThreadCache.CachedTypeIndex<SimpleDateFormats> CACHE_IDX = ThreadCache.obtainIndex(SimpleDateFormats.class, (int)1);
        private final SimpleDateFormat[] f = new SimpleDateFormat[3];

        public static SimpleDateFormats create() {
            SimpleDateFormats formats = (SimpleDateFormats)ThreadCache.takeFromCache(CACHE_IDX);
            if (formats != null) {
                return formats;
            }
            return new SimpleDateFormats();
        }

        public SimpleDateFormats() {
            this.f[0] = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            this.f[1] = new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
            this.f[2] = new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US);
            this.f[0].setTimeZone(TimeZone.getTimeZone("GMT"));
            this.f[1].setTimeZone(TimeZone.getTimeZone("GMT"));
            this.f[2].setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        public SimpleDateFormat[] getFormats() {
            return this.f;
        }

        public void recycle() {
            ThreadCache.putToCache(CACHE_IDX, (Object)this);
        }
    }

    private static class SchedulerThread
    extends Thread {
        public SchedulerThread(Runnable r, String name) {
            super(r, name);
            this.setDaemon(true);
        }
    }
}

