/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.jmx.JmxEventListener;
import org.glassfish.grizzly.http.server.jmx.Monitorable;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.RequestURIRef;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;

public class HttpHandlerChain
extends HttpHandler
implements JmxEventListener {
    private static final Logger LOGGER = Grizzly.logger(HttpHandlerChain.class);
    private ConcurrentHashMap<HttpHandler, String[]> handlers = new ConcurrentHashMap();
    private ConcurrentHashMap<HttpHandler, JmxObject> monitors = new ConcurrentHashMap();
    private Mapper mapper;
    private static final String LOCAL_HOST = "localhost";
    private boolean started;
    private final HttpServer httpServer;
    private boolean isRootConfigured = false;

    public HttpHandlerChain(HttpServer httpServer) {
        this.httpServer = httpServer;
        this.mapper = new Mapper();
        this.mapper.setDefaultHostName(LOCAL_HOST);
        this.setDecodeUrl(false);
    }

    @Override
    public void jmxEnabled() {
        for (Map.Entry<HttpHandler, String[]> entry : this.handlers.entrySet()) {
            HttpHandler httpHandler = entry.getKey();
            if (!(httpHandler instanceof Monitorable)) continue;
            this.registerJmxForHandler(httpHandler);
        }
    }

    @Override
    public void jmxDisabled() {
        for (Map.Entry<HttpHandler, String[]> entry : this.handlers.entrySet()) {
            HttpHandler httpHandler = entry.getKey();
            if (!(httpHandler instanceof Monitorable)) continue;
            this.deregisterJmxForHandler(httpHandler);
        }
    }

    @Override
    public void start() {
        for (Map.Entry<HttpHandler, String[]> entry : this.handlers.entrySet()) {
            HttpHandler httpHandler = entry.getKey();
            httpHandler.start();
        }
        this.started = true;
    }

    @Override
    public void service(Request request, Response response) throws Exception {
        block7: {
            try {
                RequestURIRef uriRef = request.getRequest().getRequestURIRef();
                DataChunk decodedURI = uriRef.getDecodedRequestURIBC();
                MappingData mappingData = request.obtainMappingData();
                this.mapUriWithSemicolon(request.getRequest().serverName(), decodedURI, 0, mappingData);
                if (mappingData.context != null && mappingData.context instanceof HttpHandler) {
                    HttpHandler httpHandler = mappingData.wrapper != null ? (HttpHandler)mappingData.wrapper : (HttpHandler)mappingData.context;
                    HttpHandlerChain.updateContextPath(request, mappingData.contextPath.toString());
                    httpHandler.setDecodeUrl(false);
                    httpHandler.doHandle(request, response);
                } else {
                    response.setStatus(HttpStatus.NOT_FOUND_404);
                    this.customizedErrorPage(request, response);
                }
            }
            catch (Throwable t) {
                try {
                    response.setStatus(HttpStatus.NOT_FOUND_404);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Invalid URL: " + request.getRequestURI(), t);
                    }
                    this.customizedErrorPage(request, response);
                }
                catch (Exception ex2) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block7;
                    LOGGER.log(Level.WARNING, "Unable to error page", ex2);
                }
            }
        }
    }

    public void addHandler(HttpHandler httpHandler, String[] mappings) {
        if (mappings.length == 0) {
            this.addHandler(httpHandler, new String[]{""});
        } else {
            if (this.started) {
                httpHandler.start();
                if (httpHandler instanceof Monitorable) {
                    this.registerJmxForHandler(httpHandler);
                }
            }
            this.handlers.put(httpHandler, mappings);
            for (String mapping : mappings) {
                String ctx = this.getContextPath(mapping);
                String wrapper = this.getWrapperPath(ctx, mapping);
                if (!ctx.equals("")) {
                    this.mapper.addContext(LOCAL_HOST, ctx, httpHandler, new String[]{"index.html", "index.htm"}, null);
                } else if (!this.isRootConfigured && wrapper.startsWith("*.")) {
                    this.isRootConfigured = true;
                    HttpHandler a = new HttpHandler(){

                        @Override
                        public void service(Request request, Response response) {
                            try {
                                this.customizedErrorPage(request, response);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    this.mapper.addContext(LOCAL_HOST, ctx, a, new String[]{"index.html", "index.htm"}, null);
                } else {
                    this.mapper.addContext(LOCAL_HOST, ctx, httpHandler, new String[]{"index.html", "index.htm"}, null);
                }
                this.mapper.addWrapper(LOCAL_HOST, ctx, wrapper, httpHandler);
            }
        }
    }

    private void registerJmxForHandler(HttpHandler httpHandler) {
        Monitorable monitorable = (Monitorable)((Object)httpHandler);
        JmxObject jmx = monitorable.createManagementObject();
        this.monitors.putIfAbsent(httpHandler, jmx);
        this.httpServer.jmxManager.register((Object)this.httpServer.managementObject, jmx, jmx.getJmxName());
    }

    private void deregisterJmxForHandler(HttpHandler httpHandler) {
        JmxObject jmx = this.monitors.get(httpHandler);
        if (jmx != null) {
            this.httpServer.jmxManager.unregister(jmx);
        }
    }

    private String getWrapperPath(String ctx, String mapping) {
        if (mapping.indexOf("*.") > 0) {
            return mapping.substring(mapping.lastIndexOf("/") + 1);
        }
        if (!ctx.equals("")) {
            return mapping.substring(ctx.length());
        }
        return mapping;
    }

    private String getContextPath(String mapping) {
        String ctx = "";
        int slash = mapping.indexOf("/", 1);
        ctx = slash != -1 ? mapping.substring(0, slash) : mapping;
        if (ctx.startsWith("/*.") || ctx.startsWith("*.")) {
            ctx = ctx.indexOf("/") == ctx.lastIndexOf("/") ? "" : ctx.substring(1);
        }
        if (ctx.startsWith("/*") || ctx.startsWith("*")) {
            ctx = "";
        }
        if (ctx.equals("/")) {
            ctx = "";
        }
        return ctx;
    }

    @Override
    public void destroy() {
        for (Map.Entry<HttpHandler, String[]> handler : this.handlers.entrySet()) {
            HttpHandler a = handler.getKey();
            a.destroy();
        }
        this.started = false;
    }

    public boolean removeHttpHandler(HttpHandler httpHandler) {
        if (httpHandler == null) {
            throw new IllegalStateException();
        }
        String[] mappings = this.handlers.remove(httpHandler);
        if (mappings != null) {
            for (String mapping : mappings) {
                String ctx = this.getContextPath(mapping);
                this.mapper.removeContext(LOCAL_HOST, ctx);
            }
            this.deregisterJmxForHandler(httpHandler);
            httpHandler.destroy();
        }
        return mappings != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapUriWithSemicolon(DataChunk serverName, DataChunk decodedURI, int semicolonPos, MappingData mappingData) throws Exception {
        CharChunk charChunk = decodedURI.getCharChunk();
        int oldEnd = charChunk.getEnd();
        if (semicolonPos == 0) {
            semicolonPos = decodedURI.indexOf(';', 0);
        }
        if (semicolonPos == -1) {
            semicolonPos = oldEnd;
        }
        charChunk.setEnd(semicolonPos);
        try {
            this.mapper.map(serverName, decodedURI, mappingData);
        }
        finally {
            charChunk.setEnd(oldEnd);
        }
    }

    public void removeAllHttpHandlers() {
        for (HttpHandler handler : this.handlers.keySet()) {
            this.removeHttpHandler(handler);
        }
    }
}

