/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.io;

import java.io.IOException;
import java.io.Writer;
import org.glassfish.grizzly.http.server.io.NIOOutputSink;
import org.glassfish.grizzly.http.server.io.OutputBuffer;
import org.glassfish.grizzly.http.server.io.WriteHandler;

public class NIOWriter
extends Writer
implements NIOOutputSink {
    private final OutputBuffer outputBuffer;

    public NIOWriter(OutputBuffer outputBuffer) {
        this.outputBuffer = outputBuffer;
    }

    @Override
    public void write(int c) throws IOException {
        this.outputBuffer.writeChar(c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.outputBuffer.write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.outputBuffer.write(cbuf, off, len);
    }

    @Override
    public void write(String str) throws IOException {
        this.outputBuffer.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.outputBuffer.write(str, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.outputBuffer.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputBuffer.close();
    }

    @Override
    public boolean canWrite(int length) {
        return this.outputBuffer.canWriteChar(length);
    }

    @Override
    public boolean notifyCanWrite(WriteHandler handler, int length) {
        return this.outputBuffer.notifyCanWrite(handler, length);
    }
}

