/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.io;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.server.io.InputBuffer;
import org.glassfish.grizzly.http.server.io.NIOInputSource;
import org.glassfish.grizzly.http.server.io.ReadHandler;

public class NIOReader
extends Reader
implements NIOInputSource {
    private final InputBuffer inputBuffer;

    public NIOReader(InputBuffer inputBuffer) {
        this.inputBuffer = inputBuffer;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        return this.inputBuffer.read(target);
    }

    @Override
    public int read() throws IOException {
        return this.inputBuffer.readChar();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.inputBuffer.read(cbuf, 0, cbuf.length);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputBuffer.skip(n, true);
    }

    @Override
    public boolean ready() throws IOException {
        return this.inputBuffer.ready();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException();
    }

    @Override
    public void reset() throws IOException {
        throw new IOException();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.inputBuffer.read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.inputBuffer.close();
    }

    @Override
    public boolean notifyAvailable(ReadHandler handler) {
        return this.inputBuffer.notifyAvailable(handler);
    }

    @Override
    public boolean notifyAvailable(ReadHandler handler, int size) {
        return this.inputBuffer.notifyAvailable(handler, size);
    }

    @Override
    public boolean isFinished() {
        return this.inputBuffer.isFinished();
    }

    @Override
    public int readyData() {
        return this.inputBuffer.availableChar();
    }

    @Override
    public boolean isReady() {
        return this.inputBuffer.availableChar() > 0;
    }

    @Override
    public Buffer getBuffer() {
        return this.inputBuffer.getBuffer();
    }
}

