/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.CharConversionException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.ServerFilterConfiguration;
import org.glassfish.grizzly.http.server.io.OutputBuffer;
import org.glassfish.grizzly.http.server.util.HtmlHelper;
import org.glassfish.grizzly.http.util.Charsets;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.RequestURIRef;

public abstract class HttpHandler {
    private static final Logger LOGGER = Grizzly.logger(HttpHandler.class);
    private boolean allowEncodedSlash = false;
    private boolean decodeURL = true;
    private Charset requestURIEncoding;
    private boolean allowCustomStatusMessage = true;

    public final void doHandle(Request request, Response response) throws Exception {
        if (request.requiresAcknowledgement() && !this.sendAcknowledgment(request, response)) {
            return;
        }
        try {
            HttpRequestPacket httpRequestPacket = request.getRequest();
            RequestURIRef requestURIRef = httpRequestPacket.getRequestURIRef();
            requestURIRef.setDefaultURIEncoding(this.requestURIEncoding);
            if (this.decodeURL) {
                try {
                    requestURIRef.getDecodedRequestURIBC(this.allowEncodedSlash);
                }
                catch (CharConversionException e) {
                    response.setStatus(HttpStatus.NOT_FOUND_404);
                    response.setDetailMessage("Invalid URI: " + e.getMessage());
                    return;
                }
            }
            response.getResponse().setAllowCustomReasonPhrase(this.allowCustomStatusMessage);
            request.parseSessionId();
            this.service(request, response);
        }
        catch (Exception t) {
            LOGGER.log(Level.SEVERE, "service exception", t);
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR_500);
            response.setDetailMessage("Internal Error");
            throw t;
        }
    }

    public abstract void service(Request var1, Response var2) throws Exception;

    public void start() {
    }

    public void destroy() {
    }

    public boolean isAllowCustomStatusMessage() {
        return this.allowCustomStatusMessage;
    }

    public void setAllowCustomStatusMessage(boolean allowCustomStatusMessage) {
        this.allowCustomStatusMessage = allowCustomStatusMessage;
    }

    public boolean isAllowEncodedSlash() {
        return this.allowEncodedSlash;
    }

    public void setAllowEncodedSlash(boolean allowEncodedSlash) {
        this.allowEncodedSlash = allowEncodedSlash;
    }

    public Charset getRequestURIEncoding() {
        return this.requestURIEncoding;
    }

    public void setRequestURIEncoding(Charset requestURIEncoding) {
        this.requestURIEncoding = requestURIEncoding;
    }

    public void setRequestURIEncoding(String requestURIEncoding) {
        this.requestURIEncoding = Charsets.lookupCharset((String)requestURIEncoding);
    }

    protected void customizedErrorPage(Request req, Response res) throws Exception {
        res.setStatus(HttpStatus.NOT_FOUND_404);
        ServerFilterConfiguration config = req.getServerFilter().getConfiguration();
        String serverName = config.getHttpServerName() + '/' + config.getHttpServerVersion();
        ByteBuffer bb = HtmlHelper.getErrorPage("Not Found", "Resource identified by path '" + req.getRequestURI() + "', does not exist.", serverName);
        res.setContentLength(bb.limit());
        res.setContentType("text/html");
        OutputBuffer out = res.getOutputBuffer();
        out.processingChars();
        out.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        out.close();
    }

    protected boolean sendAcknowledgment(Request request, Response response) throws IOException {
        if ("100-Continue".equals(request.getHeader("Expect"))) {
            response.setStatus(HttpStatus.CONINTUE_100);
            response.sendAcknowledgement();
            return true;
        }
        response.setStatus(HttpStatus.EXPECTATION_FAILED_417);
        return false;
    }

    protected void setDecodeUrl(boolean decodeURL) {
        this.decodeURL = decodeURL;
    }

    protected static void updateContextPath(Request request, String contextPath) {
        request.setContextPath(contextPath);
    }
}

